/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.extractor;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSSFImportFromXML {
    private final XSSFMap _map;
    private static POILogger logger = POILogFactory.getLogger(XSSFImportFromXML.class);

    public XSSFImportFromXML(XSSFMap map) {
        this._map = map;
    }

    public void importFromXML(String xmlInputString) throws SAXException, XPathExpressionException, ParserConfigurationException, IOException {
        Object result;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlInputString.trim())));
        List<XSSFSingleXmlCell> singleXmlCells = this._map.getRelatedSingleXMLCell();
        List<XSSFTable> tables = this._map.getRelatedTables();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(new DefaultNamespaceContext(doc));
        for (XSSFSingleXmlCell singleXmlCell : singleXmlCells) {
            String xpathString = singleXmlCell.getXpath();
            result = (Node)xpath.evaluate(xpathString, doc, XPathConstants.NODE);
            String textContent = result.getTextContent();
            logger.log(POILogger.DEBUG, (Object)("Extracting with xpath " + xpathString + " : value is '" + textContent + "'"));
            XSSFCell cell = singleXmlCell.getReferencedCell();
            logger.log(POILogger.DEBUG, (Object)("Setting '" + textContent + "' to cell " + cell.getColumnIndex() + "-" + cell.getRowIndex() + " in sheet " + cell.getSheet().getSheetName()));
            cell.setCellValue(textContent);
        }
        for (XSSFTable table : tables) {
            String commonXPath = table.getCommonXpath();
            result = (NodeList)xpath.evaluate(commonXPath, doc, XPathConstants.NODESET);
            int rowOffset = table.getStartCellReference().getRow() + 1;
            int columnOffset = table.getStartCellReference().getCol() - 1;
            for (int i = 0; i < result.getLength(); ++i) {
                for (XSSFXmlColumnPr xmlColumnPr : table.getXmlColumnPrs()) {
                    XSSFCell cell;
                    int localColumnId = (int)xmlColumnPr.getId();
                    int rowId = rowOffset + i;
                    int columnId = columnOffset + localColumnId;
                    String localXPath = xmlColumnPr.getLocalXPath();
                    localXPath = localXPath.substring(localXPath.substring(1).indexOf(47) + 1);
                    String nodeXPath = commonXPath + "[" + (i + 1) + "]" + localXPath;
                    String value = (String)xpath.evaluate(nodeXPath, result.item(i), XPathConstants.STRING);
                    logger.log(POILogger.DEBUG, (Object)("Extracting with xpath " + nodeXPath + " : value is '" + value + "'"));
                    XSSFRow row = table.getXSSFSheet().getRow(rowId);
                    if (row == null) {
                        row = table.getXSSFSheet().createRow(rowId);
                    }
                    if ((cell = row.getCell(columnId)) == null) {
                        cell = row.createCell(columnId);
                    }
                    logger.log(POILogger.DEBUG, (Object)("Setting '" + value + "' to cell " + cell.getColumnIndex() + "-" + cell.getRowIndex() + " in sheet " + table.getXSSFSheet().getSheetName()));
                    cell.setCellValue(value.trim());
                }
            }
        }
    }

    private static final class DefaultNamespaceContext
    implements NamespaceContext {
        private final Element _docElem;

        public DefaultNamespaceContext(Document doc) {
            this._docElem = doc.getDocumentElement();
        }

        public String getNamespaceURI(String prefix) {
            return this.getNamespaceForPrefix(prefix);
        }

        private String getNamespaceForPrefix(String prefix) {
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            Node parent = this._docElem;
            while (parent != null) {
                short type = parent.getNodeType();
                if (type == 1) {
                    if (parent.getNodeName().startsWith(prefix + ":")) {
                        return parent.getNamespaceURI();
                    }
                    NamedNodeMap nnm = parent.getAttributes();
                    for (int i = 0; i < nnm.getLength(); ++i) {
                        String p;
                        Node attr = nnm.item(i);
                        String aname = attr.getNodeName();
                        boolean isPrefix = aname.startsWith("xmlns:");
                        if (!isPrefix && !aname.equals("xmlns")) continue;
                        int index = aname.indexOf(58);
                        String string = p = isPrefix ? aname.substring(index + 1) : "";
                        if (!p.equals(prefix)) continue;
                        return attr.getNodeValue();
                    }
                } else {
                    if (type != 5) break;
                    continue;
                }
                parent = parent.getParentNode();
            }
            return null;
        }

        public Iterator getPrefixes(String val) {
            return null;
        }

        public String getPrefix(String uri) {
            return null;
        }
    }
}

