% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGRkaryogram.r
\name{xGRkaryogram}
\alias{xGRkaryogram}
\title{Function to visualise genomic regions using karyogram plot}
\usage{
xGRkaryogram(gr, cytoband = F, color = "royalblue", size = 0.5,
label = F, label.size = 2, label.col = "magenta", label.force = 0.05,
label.query = NULL, verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{gr}{a GenomicRange object. If the meta-column 'label' is not
provided, it will the name of this object}

\item{cytoband}{logical to indicate whether cytoband will be displayed.
By default, it sets to false}

\item{color}{the rect color. By default it is 'royalblue'}

\item{size}{the rect size}

\item{label}{logical to indicate whether to label the rect. By default,
it sets to false}

\item{label.size}{the label size}

\item{label.col}{the label color ('magenta' by default)}

\item{label.force}{the repelling force between overlapping labels}

\item{label.query}{only query will be labelled. By default, it sets to
NULL meaning all will be displayed. If labels in query can not be
found, then all will be displayed}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a ggplot object.
}
\description{
\code{xGRkaryogram} is supposed to visualise genomic regions using
manhattan plot. It returns an object of class "ggplot".
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
### GWAS catalog
GWAScatalog <- xRDataLoader('GWAScatalog',
RData.location=RData.location)
gwas <- xGR(GWAScatalog$cse_hg19, format="chr:start-end")
ind <- match(names(gwas), GWAScatalog$cse_hg19)
names(gwas) <- GWAScatalog$snp_id_current[ind]
gwas$label <- names(gwas)
gp <- xGRkaryogram(gwas)
gp
}
}
\seealso{
\code{\link{xGRkaryogram}}
}
