% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGRsep.r
\name{xGRsep}
\alias{xGRsep}
\title{Function to obtain separator index.}
\usage{
xGRsep(data)
}
\arguments{
\item{data}{input genomic regions (GR). GR should be provided as a
vector in the format of 'chrN:start-end', where N is either 1-22 or X,
start (or end) is genomic positional number; for example, 'chr1:13-20'}
}
\value{
a vector for separator index
}
\description{
\code{xGRsep} is supposed to obtain separator index.
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"

# a) provide the genomic regions
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get lead SNPs reported in AS GWAS and their significance info (p-values)
gr <- ImmunoBase$AS$variant
cse <- xGRcse(gr)

# b) sort index
ind <- xGRsort(cse)
data <- cse[ind]

# c) get separator index
vec_sep <- xGRsep(data)
}
}
\seealso{
\code{\link{xGRsep}}
}
