% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_signal_stable_V2.R
\name{extract_signal_stable_V2}
\alias{extract_signal_stable_V2}
\title{Extract signal from a wavelet spectrum using a upper and lower period boundary}
\usage{
extract_signal_stable_V2(
  wavelet = NULL,
  period_max = NULL,
  period_min = NULL,
  add_mean = TRUE,
  plot_residual = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{wavelet}{wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{period_max}{Maximum period (upper boundary) to be used to extract a cycle.}

\item{period_min}{Minimum period (lower boundary) to be used to extract a cycle.}

\item{add_mean}{Add mean to the extracted cycle \code{Default=TRUE}.}

\item{plot_residual}{Plot the signal from which the extracted cycle is subtracted \code{Default=FALSE}.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
Signal extracted from the wavelet spectra.
Output is a matrix with the first column being depth/time
and the second column is the cycle extracted from the proxy record.
}
\description{
Extract a signal from the wavelet using a upper and lower period boundary
}
\examples{
#Example in which the ~210yr de Vries cycle is extracted from the Total Solar
# Irradiance data set of Steinhilber et al., (2012)

TSI_wt <-
analyze_wavelet(
data = TSI,
dj = 1/200,
lowerPeriod = 16,
upperPeriod = 8192,
   verbose = FALSE,
   omega_nr = 6
 )

de_Vries_cycle <- extract_signal_stable_V2(wavelet=TSI_wt,
period_max = 240,
period_min = 180,
add_mean=TRUE,
plot_residual=FALSE,
keep_editable=FALSE)


}
\references{
Angi Roesch and Harald Schmidbauer (2018). WaveletComp: Computational
Wavelet Analysis. R package version 1.1.
\url{https://CRAN.R-project.org/package=WaveletComp}

Gouhier TC, Grinsted A, Simko V (2021). R package biwavelet: Conduct Univariate and Bivariate Wavelet Analyses. (Version 0.20.21),
\url{https://github.com/tgouhier/biwavelet}

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
Bulletin of the American Meteorological Society 79:61-78.
\url{https://paos.colorado.edu/research/wavelets/bams_79_01_0061.pdf}
}
\author{
Code based on the reconstruct function of the 'WaveletComp' R package
which is based on the wavelet 'MATLAB' code written by Christopher Torrence and Gibert P. Compo (1998).
}
