% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GainCurve.R
\name{GainCurvePlotWithNotation}
\alias{GainCurvePlotWithNotation}
\title{Take the standard WVPlots gain curve and add extra notation}
\usage{
GainCurvePlotWithNotation(frame, xvar, truthVar, title, gainx, labelfun, ...,
  compute_sig = TRUE, large_count = 1000)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{gainx}{the point on the x axis corresponding to the desired label}

\item{labelfun}{a function to return a label for the marked point}

\item{...}{no unarmed argument, added to force named binding of later arguments.}

\item{compute_sig}{logical, if TRUE compute significance}

\item{large_count}{numeric, number of plotting points to consider large (and cut down).}
}
\description{
Take the standard WVPlots gain curve and add extra notation
}
\examples{

set.seed(34903490)
y = abs(rnorm(20)) + 0.1
x = abs(y + 0.5*rnorm(20))
frm = data.frame(model=x, value=y)
frm$costs=1
frm$costs[1]=5
frm$rate = with(frm, value/costs)
frm$isValuable = (frm$value >= as.numeric(quantile(frm$value, probs=0.8)))
gainx = 0.10  # get the top 10\% most valuable points as sorted by the model
# make a function to calculate the label for the annotated point
labelfun = function(gx, gy) {
  pctx = gx*100
  pcty = gy*100

  paste("The top ", pctx, "\% most valuable points by the model\\n",
        "are ", pcty, "\% of total actual value", sep='')
}
WVPlots::GainCurvePlotWithNotation(frm, "model", "value",
   title="Example Gain Curve with annotation",
   gainx=gainx,labelfun=labelfun)

}
