% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridplot.R
\name{gridplot}
\alias{gridplot}
\alias{gridplot.tidal}
\alias{gridplot.tidalmean}
\title{Plot variable response to salinity/flow as a gridded surface for all months}
\usage{
gridplot(dat_in, ...)

\method{gridplot}{tidal}(dat_in, month = c(1:12), tau = NULL,
  years = NULL, col_vec = NULL, col_lim = NULL, logspace = TRUE,
  floscl = TRUE, allflo = FALSE, flo_fac = 3, yr_fac = 3, ncol = NULL,
  grids = FALSE, pretty = TRUE, ...)

\method{gridplot}{tidalmean}(dat_in, month = c(1:12), years = NULL,
  col_vec = NULL, col_lim = NULL, logspace = TRUE, floscl = TRUE,
  allflo = FALSE, flo_fac = 3, yr_fac = 3, ncol = NULL, grids = FALSE,
  pretty = TRUE, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to other methods}

\item{month}{numeric indicating months to plot or chr string 'all' to indicate all months with no plot facets}

\item{tau}{numeric vector of quantile to plot.  The function will plot the 'middle' quantile if none is specified, e.g., if 0.2, 0.3, and 0.4 are present in the fitted model object then 0.3 will be plotted.}

\item{years}{numeric vector for range of years to plot}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}} and \code{\link[ggplot2]{scale_fill_gradientn}} for grid shading.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{col_lim}{numeric vector of length two that defines the range of the color ramp in the legend, passed to \code{\link[ggplot2]{scale_fill_gradient}}.  This is useful for fixing the color range to evaluate multiple plots.}

\item{logspace}{logical indicating if plots are in log space}

\item{floscl}{logical indicating if salinity/flow on x-axis is standardized (default) or in original scale}

\item{allflo}{logical indicating if the salinity/flow values for plotting are limited to the fifth and ninety-fifth percentile of observed values for the month of interest}

\item{flo_fac}{numeric value indicating the factor for smoothing the response variable across salinity/flow values. Increasing the value creates more smoothing and setting the value to 1 removes all smoothing.}

\item{yr_fac}{numeric value indicating the factor for smoothing the response variable across integer years. Increasing the value creates more smoothing and setting the value to 1 removes all smoothing.}

\item{ncol}{numeric argument passed to \code{\link[ggplot2]{facet_wrap}} indicating number of facet columns}

\item{grids}{logical indicating if grid lines are present}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot the relationship between the response variable and salinity/flow across the time series using a gridded surface for all months.   The response is shaded by relative values across all dates for comparison.
}
\details{
These plots can be used to examine how the relationship between the response variable and salinity/flow varies throughout the time series for multiple months.  The plot is similar to that returned by \code{\link{dynaplot}} except changes in the response are shown on a gridded surface of salinity/flow versus time.  Multiple months can also be viewed.  Color shading is in proportion to the value of the response variable and is relative across the plotted months.  The interpolation grid that is stored as an attribute in a fitted tidal object is used to create the plot.  By default, the plots are constrained to the fifth and ninety-fifth percentile of observed salinity/flow values during each month to limit the predictions within the data domain. This behavior can be suppressed by changing the \code{allflo} argument, although the predicted values of the response variable that are outside of the salinity/flow range for the plotted month are typically unrealistic.
}
\examples{
\dontrun{
## load a fitted tidal object
data(tidfit)

## defaults to the fiftieth quantile
gridplot(tidfit)

## no facets, all months
gridplot(tidfit, month = 'all')

## change the defaults
gridplot(tidfit, tau = c(0.1), month = c(3, 6, 9, 12), 
 col_vec = c('red', 'blue', 'green'), flo_fac = 1)
 
## plot a tidalmean object
data(tidfitmean)

gridplot(tidfitmean)

}
}
\seealso{
\code{\link{dynaplot}}, \code{\link{fitplot}}, \code{\link{gridplot}}, \code{\link{prdnrmplot}}
}
