% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrtdscv.R
\name{wrtdscv}
\alias{wrtdscv}
\alias{wrtdscv.default}
\title{Use k-fold cross-validation to evaluate WRTDS model fit}
\usage{
wrtdscv(dat_in, ...)

\method{wrtdscv}{default}(dat_in, wins, k = 10, seed_val = 123,
  trace = TRUE, ...)
}
\arguments{
\item{dat_in}{input tidal or tidamean object}

\item{...}{arguments passed to \code{\link{wrtds}} or \code{\link{getwts}}, e.g., \code{tau = 0.2} if a \code{tidal} object is used for \code{dat_in}}

\item{wins}{list of input half-window widths of the order months, years, and salinity/flow, passed to \code{\link{getwts}}}

\item{k}{number of folds to evaluate}

\item{seed_val}{seed to keep the same dataset divisions between window width comparisons}

\item{trace}{logical indicating if progress is printed in the console}
}
\value{
Overall error is the average of all errors for each fold.
}
\description{
Use k-fold cross-validation to evaluate WRTDS model fit based on supplied half-window widths.
}
\details{
Default number of folds is ten.  Each fold can be evaluated with multiple cores if a parallel back end is created prior to running the function (see the examples).  This will greatly increase processing speed unless k is set to a small number.
}
\examples{
\dontrun{

library(doParallel)
ncores <- detectCores() - 1  
registerDoParallel(cores = ncores)

# half-window widths to evaluate
# months, years, and salinity/flow
wins <- list(0.5, 10, 0.5) 

# get ocv score for k = 10
wrtdscv(tidobjmean, wins = wins)

# get ocv score k = 2, tau = 0.2 
wrtdscv(tidobj, wins = wins, tau = 0.2)
}
}
\seealso{
\code{\link{getwts}}, \code{\link{wtsplot}}, \code{\link{winsrch_grid}}, \code{\link{winsrch_optim}}
}

