% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rpoisgamma_rcpp}
\alias{rpoisgamma_rcpp}
\title{Draw time to event (tte) from a Poisson or Poisson-Gamma (PG) Mixture/Negative Binomial (NB) Process using C++}
\usage{
rpoisgamma_rcpp(
  n,
  rate,
  theta = NULL,
  obs_time = 1,
  t_reps = NULL,
  seed = NULL,
  return_ind_rate = FALSE,
  return_df = FALSE
)
}
\arguments{
\item{n}{The number of observations to be drawn}

\item{rate}{rate of the event (events per unit time)}

\item{theta}{Optional. If provided, Poisson-Gamma (NB). Represents gamma shape.}

\item{obs_time}{period over which events are observable}

\item{t_reps}{Optional. Number of TBEs to be generated to capture events within the observation window.}

\item{seed}{Optional integer seed for reproducibility.}

\item{return_ind_rate}{Logical: include individual rate vector in output when theta provided.}

\item{return_df}{Logical: return a data.frame with event-level rows (if TRUE).}
}
\value{
If return_df=TRUE: a data.frame (or NULL if no events). Else: list with tte and optionally ind_rate.
}
\description{
Draw time to event (tte) from a Poisson or Poisson-Gamma (PG) Mixture/Negative Binomial (NB) Process using C++
}
\examples{
rpoisgamma_rcpp(1, rate = 1, obs_time = 1, theta = 1)



}
