% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniTools.R
\name{import3}
\alias{import3}
\title{Import the three W4M tables}
\usage{
import3(pathDM, pathSM, pathVM, disable_comm = TRUE)
}
\arguments{
\item{pathDM}{a path to a file corresponding to the dataMatrix}

\item{pathSM}{a path to a file corresponding to the sampleMetadata}

\item{pathVM}{a path to a file corresponding to the variableMetadata}

\item{disable_comm}{a \code{boolean} with default to \code{TRUE} to indicate
whether the comment character \code{#} should be disabled as a comment tag
for the import of the metadata files; when \code{TRUE}, \code{#} in the
metadata table's columns will be considered as any other character.}
}
\value{
a \code{list} containing three elements:
\itemize{
\item dataMatrix a \code{data.frame} corresponding to the imported dataMatrix table;
\item sampleMetadata a \code{data.frame} corresponding to the imported sampleMetadata table;
\item variableMetadata a \code{data.frame} corresponding to the imported variableMetadata table
}
}
\description{
import3
Function to import the three W4M tables from files
(dataMatrix, sampleMetadata, variableMetadata)
import3 performs checks to ensure the identifiers match between
the three tables and stops with an explicit error message in case
identifiers do not match.
}
\examples{
\donttest{

dm_path <- system.file(
  "extdata",
  "mini_datamatrix.txt",
  package="W4MRUtils"
)
vm_path <- system.file(
  "extdata",
  "mini_variablemetadata.txt",
  package="W4MRUtils"
)
sm_path <- system.file(
  "extdata",
  "mini_samplemetadata.txt",
  package="W4MRUtils"
)

## import considering # is not a comment character
A <- W4MRUtils::import3(dm_path, sm_path, vm_path)
print(A$dataMatrix[1:5, 1:5])
print(A$sampleMetadata[1:5, ])
print(A$variableMetadata[1:5, ])

## import considering # is a comment character
B <- W4MRUtils::import3(dm_path, sm_path, vm_path, disable_comm = FALSE)
print(B$dataMatrix[1:5, 1:5])
print(B$sampleMetadata[1:5, ])
print(B$variableMetadata[1:5, ])
}

}
\author{
M.Petera
}
