% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cql-predicates.R
\name{cql_geom_predicates}
\alias{cql_geom_predicates}
\alias{EQUALS}
\alias{DISJOINT}
\alias{INTERSECTS}
\alias{TOUCHES}
\alias{CROSSES}
\alias{WITHIN}
\alias{CONTAINS}
\alias{OVERLAPS}
\alias{RELATE}
\alias{BBOX}
\alias{DWITHIN}
\alias{BEYOND}
\title{CQL Geometry Predicates}
\usage{
EQUALS(geom)

DISJOINT(geom)

INTERSECTS(geom)

TOUCHES(geom)

CROSSES(geom)

WITHIN(geom)

CONTAINS(geom)

OVERLAPS(geom)

RELATE(geom, pattern)

BBOX(coords, crs = NULL)

DWITHIN(
  geom,
  distance,
  units = c("meters", "feet", "statute miles", "nautical miles", "kilometers")
)

BEYOND(
  geom,
  distance,
  units = c("meters", "feet", "statute miles", "nautical miles", "kilometers")
)
}
\arguments{
\item{geom}{an \code{sf}/\code{sfc}/\code{sfg} or \code{bbox} object (from the \code{sf} package)}

\item{pattern}{spatial relationship specified by a DE-9IM matrix pattern.
A DE-9IM pattern is a string of length 9 specified using the characters
\verb{*TF012}. Example: \code{'1*T***T**'}}

\item{coords}{the coordinates of the bounding box as four-element numeric
vector \code{c(xmin, ymin, xmax, ymax)}, a \code{bbox} object from the \code{sf}
package (the result of running \code{sf::st_bbox()} on an \code{sf} object), or
an \code{sf} object which then gets converted to a bounding box on the fly.}

\item{crs}{(Optional) A numeric value or string containing an SRS code. If
\code{coords} is a \code{bbox} object with non-empty crs, it is taken from that.
(For example, \code{'EPSG:3005'} or just \code{3005}. The default is to use the CRS of
the queried layer)}

\item{distance}{numeric value for distance tolerance}

\item{units}{units that distance is specified in. One of
\code{"feet"}, \code{"meters"}, \code{"statute miles"}, \code{"nautical miles"}, \code{"kilometers"}}
}
\value{
a CQL expression to be passed on to the WFS call
}
\description{
Functions to construct a CQL expression to be used
to filter results from \code{\link[=vicmap_query]{vicmap_query()}}.
See \href{https://docs.geoserver.org/stable/en/user/filter/ecql_reference.html#spatial-predicate}{the geoserver CQL documentation for details}.
The sf object is automatically simplified to a less complex sf object
to reduce the complexity of the Web Service call. Subsequent in-memory
filtering may be needed to achieve exact results.
}
\details{
The code for these cql predicates was developed by the bcdata team: \url{https://bcgov.github.io/bcdata/reference/cql_geom_predicates.html}
}
