\name{invexpexp}
\alias{dinvexpexp}
\alias{pinvexpexp}
\alias{varinvexpexp}
\alias{esinvexpexp}
\title{Inverse exponentiated exponential distribution}
\description{Computes the pdf, cdf, value at risk and expected shortfall for the inverse exponentiated exponential distribution due to Ghitany et al. (2013) given by
\deqn{\begin{array}{ll}
&\displaystyle
f (x) = a \lambda x^{-2} \exp \left(-\frac {\lambda}{x} \right)
\left[ 1 - \exp \left( -\frac {\lambda}{x} \right) \right]^{a - 1},
\\
&\displaystyle
F (x) = 1 - \left[ 1 - \exp \left( -\frac {\lambda}{x} \right) \right]^a,
\\
&\displaystyle
{\rm VaR}_p (X) = \lambda \left\{ -\log \left[ 1 - (1 - p)^{1 / a} \right] \right\}^{-1},
\\
&\displaystyle
{\rm ES}_p (X) = \frac {\lambda}{p} \int_0^p \left\{ -\log \left[ 1 - (1 - v)^{1 / a} \right] \right\}^{-1} dv
\end{array}}
for \eqn{x > 0}, \eqn{0 < p < 1}, \eqn{a > 0}, the shape parameter and \eqn{\lambda > 0}, the scale parameter.}
\usage{
dinvexpexp(x, lambda=1, a=1, log=FALSE)
pinvexpexp(x, lambda=1, a=1, log.p=FALSE, lower.tail=TRUE)
varinvexpexp(p, lambda=1, a=1, log.p=FALSE, lower.tail=TRUE)
esinvexpexp(p, lambda=1, a=1)
}
\arguments{
  \item{x}{scaler or vector of values at which the pdf or cdf needs to be computed}
  \item{p}{scaler or vector of values at which the value at risk or expected shortfall needs to be computed}
  \item{lambda}{the value of the scale parameter, must be positive, the default is 1}
  \item{a}{the value of the shape parameter, must be positive, the default is 1}
  \item{log}{if TRUE then log(pdf) are returned}
  \item{log.p}{if TRUE then log(cdf) are returned and quantiles are computed for exp(p)}
  \item{lower.tail}{if FALSE then 1-cdf are returned and quantiles are computed for 1-p}
}
\value{An object of the same length as \code{x}, giving the pdf or cdf values computed at \code{x} or an object of the same length as \code{p}, giving the values at risk or expected shortfall computed at \code{p}.}
\references{S. Nadarajah, S. Chan and E. Afuecheta, An R Package for value at risk and expected shortfall, submitted}
\author{Saralees Nadarajah}
\examples{x=runif(10,min=0,max=1)
dinvexpexp(x)
pinvexpexp(x)
varinvexpexp(x)
esinvexpexp(x)}
\keyword{Value at risk, expected shortfall}
