% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmdr.R
\name{vmd}
\alias{vmd}
\title{Variational Mode Decomposition (1- or 2-dimensional)}
\usage{
vmd(data, alpha, tau, K, DC, init, tol, verbose = FALSE)
}
\arguments{
\item{data}{either a vector or a matrix (of type numeric or integer)}

\item{alpha}{a numeric value specifying the balancing parameter of the data-fidelity constraint}

\item{tau}{a numeric value specifying the time-step of the dual ascent ( pick 0 for noise-slack )}

\item{K}{a numeric value specifying the number of modes to be recovered}

\item{DC}{a boolean. If true the first mode is put and kept at DC (0-freq)}

\item{init}{a numeric value. This parameter differs depending on the input 'data' parameter (1-dimensional and 2-dimensional). See the details section for more information}

\item{tol}{a numeric value specifying the tolerance of convergence criterion (typically this parameter is around 1e-6 for the 1-dimensional and 1e-7 for the 2-dimensional data)}

\item{verbose}{a boolean. If TRUE then information will be printed in the console}
}
\value{
a list object of length three which includes the
\itemize{
\item 'u' (collection of decomposed modes)
\item 'u_hat' (spectra of the modes)
\item 'omega' (estimated mode center-frequencies)
objects
}
}
\description{
Variational Mode Decomposition (1- or 2-dimensional)
}
\details{
The 'init' parameter takes the following values for,
\itemize{
\item 1-dimensional data:
\itemize{
\item 0 = all omegas start at 0
\item 1 = all omegas start uniformly distributed
\item 2 = all omegas initialized randomly
}
\item 2-dimensional data:
\itemize{
\item 0 = all omegas start at 0
\item 1 = all omegas start initialized randomly
}
}
}
\examples{

require(VMDecomp)

#..............
# 1-dimensional
#..............

N = 250

set.seed(1)
rand_unif = runif(n = N, min = 0, max = 1.0)

f_sig1 = 6 * rand_unif
f_sig2 = cos(x = 8 * pi * rand_unif)
f_sig3 = 0.5 * cos(x = 40 * pi * rand_unif)

f_sig = f_sig1 + f_sig2 + f_sig3

alpha = 2000
tau = 0
K = 3
DC = FALSE
init = 1
tol = 1e-6

set.seed(2)
res_1d = vmd(data = f_sig,
             alpha = alpha,
             tau = tau,
             K = K,
             DC = DC,
             init = init,
             tol = tol,
             verbose = FALSE)

#..............
# 2-dimensional
#..............

rows_cols = 10

set.seed(3)
data = matrix(runif(rows_cols^2), rows_cols, rows_cols)
alpha = 5000
tau = 0.25
K = 2
DC = TRUE
init = 1
tol = 1e-7

set.seed(4)
res_2d = vmd(data = data,
             alpha = alpha,
             tau = tau,
             K = K,
             DC = DC,
             init = init,
             tol = tol,
             verbose = FALSE)
}
\references{
https://math.montana.edu/dzosso/code/
}
