% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{varPlot}
\alias{varPlot}
\title{Variability Chart for Hierarchical Models.}
\usage{
varPlot(form, Data, keep.order = TRUE, type = c(1L, 2L, 3L)[1],
  VARtype = "SD", htab = 0.5, Title = NULL, VSpace = NULL,
  VarLab = list(cex = 0.75, adj = c(0.5, 0.5)), YLabel = list(text =
  "Value", side = 2, line = 3.5, cex = 1.5), SDYLabel = list(side = 2, line =
  2.5), Points = list(pch = 16, cex = 0.5, col = "black"), SDs = list(pch =
  16, col = "blue", cex = 0.75), SDline = list(lwd = 1, lty = 1, col =
  "blue"), BG = list(border = "lightgray", col.table = FALSE),
  VLine = list(lty = 1, lwd = 1, col = "gray90"), HLine = NULL,
  Join = list(lty = 1, lwd = 1, col = "gray"), JoinLevels = NULL,
  Mean = list(pch = 3, col = "red", cex = 0.5), MeanLine = NULL,
  Boxplot = NULL, VCnam = list(cex = 0.75, col = "black", line = 0.25),
  useVarNam = FALSE, ylim = NULL, max.level = 25, ...)
}
\arguments{
\item{form}{(formula) object specifying the model, NOTE: any crossed factors are reduced to last term of the crossing structure, i.e.
"a:b" is reduced to "b", "a:b:c" is reduced to "c".}

\item{Data}{(data.frame) with the data}

\item{keep.order}{(logical) TRUE = the ordering of factor-levels is kept as provided by 'Data', FALSE = factor-levels are sorted on 
and within each level of nesting.}

\item{type}{(integer) specifying the type of plot to be used, options are 1 = regular scatterplot, 2 = plot of the standard deviation,
3 = both type of plots.}

\item{VARtype}{(character) either "SD" (standard deviation) or "CV" (coefficient of variation), controls which type of measures is used to
report variability in plots when 'type' is set to either 2 or  (see 'type' above). Note that all parameters which apply to
the SD-plot will be used for the CV-plot in case 'VARtype="CV"'.}

\item{htab}{(numeric) value 0 < htab < 1 specifying the height of the table representing the experimental design. This value represents
the proportion in relation to the actual plotting area, i.e. htab=1 mean 50\% of the vertical space is reserved for the table.}

\item{Title}{(list) specifying all parameters applicable in function \code{\link{title}} for printing main- or sub-titles to plots. If 'type==3',
these settings will apply to each plot. For individual settings specify a list with two elements, where each element is a
   list itself specifying all parameters of function 'title'. The first one is used for the variability chart, 
   the second one for the SD or CV plot. Set to NULL to omit any titles.}

\item{VSpace}{(numeric) vector of the same length as there are variance components, specifying the proportion of vertical space assigned
to each variance component in the tabular indicating the model structure. These elements have to sum to 1, otherwise equal
   sizes will be used for each VC.}

\item{VarLab}{(list) specifying all parameters applicable in function \code{\link{text}}, used to add labels within the table environment refering
to the nesting structure. This can be a list of lists, where the i-th list corresponds to the i-th variance component, counted
in bottom-up direction, i.e. starting from the most general variance component ('day' in the 1st example).}

\item{YLabel}{(list) specifying all parameters applicable in function \code{\link{mtext}}, used for labelling the Y-axis.}

\item{SDYLabel}{(list) specifying all parameters applicable in function \code{\link{mtext}}, used for labelling the Y-axis.}

\item{Points}{(list) specifying all parameters applicable in function \code{\link{points}}, used to specify scatterplots per lower-end factor-level
(e.g. 'run' in formula run/day). If list-elements "col", "pch", "bg" and "cex" are lists themselves with elements "var" and "col"/"pch"/"bg"/"cex", 
   where the former specifies a variable used for assigning colors/symbols/backgrounds/sizes according to the class-level of
   variable "var", point-colors/plotting-symbols/plotting-symbol backgrounds/plotting-symbol sizes can be used for indicating
   specific sub-classes not addressed by the model/design or indicate any sort of information (see examples).
   Note the i-th element of 'col'/'pch' refers of the i-th element of unique(Data$var), even if 'var' is an integer variable.}

\item{SDs}{(list) specifying all parameters applicable in function \code{\link{points}}, used to specify the appearance of SD-plots.}

\item{SDline}{(list) specifying all parameters applicable in function \code{\link{lines}}, used to specify the (optional) line joining individual SDs,
Set to NULL to omit.}

\item{BG}{(list) specifying the background for factor-levels of a nested factor. This list is passed on to function \code{\link{rect}} after element
'var', which identifies the factor to be used for coloring, has been removed. If not set to NULL and no factor has been specified by the
user, the top-level factor is selected by default. If this list contains element 'col.table=TRUE', the same coloring schema is used
   in the table below at the corresponding row/factor (see examples). Addionally, list-elment 'col.bg=FALSE' can be used to turn off
   BG-coloring, e.g. if only the the respective row in the table below should be color-coded (defaults to 'col.bg=TRUE').
   When specifying as many colors as there are factor-levels, the same color will be applied to a factor-level automatically. 
   This is relevant for factors, which are not top-level (bottom in the table).
Example: BG=list(var="run", col=c("white", "lightgray"), border=NA) draws the background for alternating levels of factor "run" 
white and gray for better visual differentiation. Set to NULL to omit. Use list( ..., col="white", border="gray") for using gray 
vertical lines for separation. See argument 'VLine' for additional highlighting options of factor-levels.}

\item{VLine}{(list) specifying all parameters applicable in \code{\link{lines}} optionally separating levels of one or multiple variables
as vertical lines. This is useful in addition to 'BG' (see examples), where automatically 'border=NA' will be set that 'VLine' will
take full effect. If this list contains element 'col.table=TRUE', vertical lines will be extended to the table below the plot.}

\item{HLine}{(list) specifying all parameters applicable in function \code{\link{abline}} to add horizontal lines. Only horizontal lines can be
set specifying the 'h' parameter. 'HLine=list()' will use default settings. 'HLine=NULL' will omit horizontal lines.
In case 'type=3', two separate lists can be specified where the first list applies to the variability chart and the second list
to the SD-/CV-chart.}

\item{Join}{(list) specifying all parameter applicable in function \code{\link{lines}} controlling how observed values within lower-level factor-levels,
are joined. Set to NULL to omit.}

\item{JoinLevels}{(list) specifying all arguments applicable in function \code{\link{lines}}, joining factor-levels nested within higher order factor levels,
list-element "var" specifies this variable}

\item{Mean}{(list) passed to function \code{\link{points}} specifying plotting symbols used to indicate mean values per lower-level factor-level, 
set equal to NULL to omit.}

\item{MeanLine}{(list) passed to function \code{\link{lines}} specifying the appearance of horizontal lines indicating mean values of factor levels. 
The factor variable for which mean-values of factor-levels are plotted can be specified via list-element "var" accepting any factor 
variable specified in 'form'. List element "mar" takes values in [0;.5] setting the left and right margin size of mean-lines.
Set equal to NULL to omit. Use 'var="int"' for specifying the overall mean (grand mean, intercept).
If this list contains logical 'join' which is set to TRUE, these mean lines will be joined. If list-element "top" is set to TRUE, 
these lines will be plotted on top, which is particularily useful for very large datasets.}

\item{Boxplot}{(list) if not NULL, a boxplot of all values within the smallest possible subgroup (replicates) will be added to the plot,
On can set list-elements 'col.box="gray65"', 'col.median="white"', 'col.whiskers="gray65"' specifying different colors and 'lwd=3'
for the line width of the median-line and whiskers-lines as well as 'jitter=1e3' controlling the jittering of points around the
center of the box in horizontal direction, smallest possible value is 5 meaning the largest amount of jittering (1/5 in both directions)
value is)}

\item{VCnam}{(list) specifying the text-labels (names of variance components) appearing as axis-labels. These parameters are passed to function
\code{\link{mtext}}. Parameter 'side' can only be set to 2 (left) or 4 (right) controlling where names of variance components appear. 
   Set to NULL to omit VC-names.}

\item{useVarNam}{(logical) TRUE = each factor-level specifier is pasted to the variable name of the current variable and used as list-element name, 
FALSE = factor-level specifiers are used as names of list-elements; the former is useful when factor levels are indicated
as integers, e.g. days as 1,2,..., the latter is useful when factor levels are already unique, e.g. day1, day2, ... .}

\item{ylim}{(numeric) vector of length two, specifying the limits in Y-direction, if not set these values will be determined automatically.
In case of plot 'type=3' this can also be a list of two ylim-vectors, first corresponding to the variability chart, second to the
plot of error variability per replicate group}

\item{max.level}{(integer) specifying the max. number of levels of a nested factor in order to draw vertical lines. If there are too many levels a black
area will be generated by many vertical lines. Level names will also be omitted.}

\item{...}{further graphical parameters passed on to function 'par', e.g. use 'mar' for specification of margin widths. Note, that not all of them
will have an effect, because some are fixed ensuring that a variability chart is drawn.}
}
\value{
(invisibly) returns 'Data' with additional variable 'Xcoord' giving X-coordinates of each observation
}
\description{
Function \code{varPlot} determines the sequence of variables in the model formula and uses this information to construct
the variability chart.
}
\details{
This function implements a variability-chart, known from, e.g. JMP (JMP, SAS Institute Inc., Cary, NC). 
Arbitrary models can be specified via parameter 'form'. Formulas will be reduced to a simple hierarchical structure 
ordering factor-variables according to the order of appearance in 'form'. This is done to make function \code{varPlot} 
applicable to any random model considered in this package. 
Even if there are main factors, neither one being above or below another main factor, these are forced into a hierachy.
Besides the classic scatterplot, where observations are plotted in sub-classes emerging from the model formula, a plot of
standard deviations (SD) or coefficients of variation (CV) is provided (type=2) or both types of plots together (type=3).
}
\examples{
\dontrun{

# load data (CLSI EP05-A2 Within-Lab Precision Experiment)
data(dataEP05A2_3)

# two additional classification variables (without real interpretation)
dataEP05A2_3$user <- sample(rep(c(1,2), 40))
dataEP05A2_3$cls2 <- sample(rep(c(1,2), 40))

# plot data as variability-chart, using automatically determined parameter 
# settings (see 'dynParmSet')
varPlot(y~day/run, dataEP05A2_3)

# display intercept (total mean)
varPlot(y~day/run, dataEP05A2_3, MeanLine=list(var="int"))

# use custom VC-names
varPlot(y~day/run, dataEP05A2_3, VCnam=list(text=c("_Day", "_Run")))

# re-plot now also indicating dayly means as blue horizontal lines
varPlot(y~day/run, dataEP05A2_3, MeanLine=list(var=c("day", "int"), col="blue"))

# now use variable-names in names of individual factor-levels and use a different 
# notation of the nesting structure
varPlot(y~day+day:run, dataEP05A2_3, useVarNam=TRUE)

# rotate names of 2nd VC
varPlot(y~day+day:run, dataEP05A2_3, useVarNam=TRUE, VarLab=list(list(font=2), list(srt=60)))

# use alternating backgrounds for each level of factor "day" 
# (top-level factor is default) 
# use a simplified model formula (NOTE: only valid for function 'varPlot')
varPlot(y~day+run, dataEP05A2_3, BG=list(col=c("gray70", "gray90"), border=NA))

# now also color the corresponding row in the table accordingly
varPlot( y~day+run, dataEP05A2_3, 
         BG=list(col=c("gray70", "gray90"), border=NA, col.table=TRUE))

# assign different point-colors according to a classification variable
# not part of the model (artificial example in this case)
varPlot( y~day+day:run, dataEP05A2_3, mar=c(1,5,1,7), VCnam=list(side=4),
         Points=list(col=list(var="user", col=c("red", "green"))) )

# always check order of factor levels before annotating
order(unique(dataEP05A2_3$user))

# add legend to right margin
legend.m(fill=c("green", "red"), legend=c("User 1", "User 2"))

# assign different plotting symbols according to a classification
# variable not part of the model
varPlot( y~day+day:run, dataEP05A2_3, mar=c(1,5,1,7), VCnam=list(side=4), 
         Points=list(pch=list(var="user", pch=c(2, 8))) )

# add legend to right margin
legend.m(pch=c(8,2), legend=c("User 1", "User 2"))

# assign custom plotting symbols by combining 'pch' and 'bg'
varPlot( y~day+day:run, dataEP05A2_3, 
         Points=list(pch=list(var="user", pch=c(21, 24)),
                     bg=list( var="user", bg=c("lightblue", "yellow"))) )

# assign custom plotting symbols by combining 'pch', 'bg', and 'cex'      
varPlot( y~day+day:run, dataEP05A2_3,                                    
         Points=list(pch=list(var="user", pch=c(21, 24)),                
                     bg =list(var="user", bg=c("lightblue", "yellow")),
                     cex=list(var="user",  cex=c(2,1))) )

# now combine point-coloring and plotting symbols
# to indicate two additional classification variables
varPlot( y~day+day:run, dataEP05A2_3, mar=c(1,5,1,10), 
         VCnam=list(side=4, cex=1.5),
         Points=list(col=list(var="user", col=c("red", "darkgreen")), 
                     pch=list(var="cls2", pch=c(21, 22)),
                     bg =list(var="user", bg =c("orange", "green"))) )

# add legend to (right) margin
 legend.m( margin="right", pch=c(21, 22, 22, 22), 
           pt.bg=c("white", "white", "orange", "green"), 
           col=c("black", "black", "white", "white"), 
           pt.cex=c(1.75, 1.75, 2, 2), 
           legend=c("Cls2=1", "Cls2=2", "User=2", "User=1"),
           cex=1.5)

# use blue lines between each level of factor "run" 
varPlot(y~day/run, dataEP05A2_3, BG=list(var="run", border="blue"))

# plot SDs for each run
varPlot(y~day+day:run, dataEP05A2_3, type=2)

# use CV instead of SD
varPlot(y~day/run, dataEP05A2_3, type=2, VARtype="CV")

# now plot variability-chart and SD-plot in one window
varPlot(y~day/run, dataEP05A2_3, type=3, useVarNam=TRUE)

# now further customize the plot
varPlot( y~day/run, dataEP05A2_3, BG=list(col=c("lightgray", "gray")),
         YLabel=list(font=2, col="blue", cex=1.75, text="Custom Y-Axis Label"),
         VCnam=list(col="red", font=4, cex=2),
         VarLab=list(list(col="blue", font=3, cex=2), list(cex=1.25, srt=-15)))

# create variability-chart of the example dataset in the CLSI EP05-A2 
# guideline (listed on p.25)
data(Glucose,package="VCA")
varPlot(result~day/run, Glucose, type=3)

# use individual settings of 'VarLab' and 'VSpace' for each variance component
varPlot(result~day/run, Glucose, type=3, 
        VarLab=list(list(srt=45, col="red", font=2), 
        list(srt=90, col="blue", font=3)), VSpace=c(.25, .75))

# set individual titles for both plot when 'type=3'
# and individual 'ylim' specifications
varPlot(	result~day/run, Glucose, type=3, 
         Title=list(list(main="Variability Chart"), 
                    list(main="Plot of SD-Values")),
			ylim=list(c(230, 260), c(0, 10)))

# more complex experimental design
data(realData)
Data <- realData[realData$PID == 1,]
varPlot(y~lot/calibration/day/run, Data, type=3)

# improve visual appearance of the plot
varPlot(y~lot/calibration/day/run, Data, type=3, keep.order=FALSE,
        BG=list(var="calibration", col=c("white", "lightgray")))

# add horizontal lines indicating mean-value for each factor-level of all variables
varPlot(y~lot/calibration/day/run, Data, type=3, keep.order=FALSE,
        BG=list(var="calibration", 
                col=c("aquamarine","antiquewhite2","antiquewhite4",
                      "antiquewhite1","aliceblue","antiquewhite3",
                      "white","antiquewhite","wheat" ), 
                col.table=TRUE),
        MeanLine=list(var=c("lot", "calibration", "day", "int"), 
                      col=c("orange", "blue", "darkgreen", "yellow"), 
                      lwd=c(2,2,2,2)))

# now also highlight bounds between factor levels of "lot" and "day" 
# as vertical lines and extend them into the table (note that each 
# variable needs its specific value for 'col.table')
varPlot(y~lot/calibration/day/run, Data, type=3, keep.order=FALSE,
        BG=list(var="calibration", 
                col=c("aquamarine","antiquewhite2","antiquewhite4",
                      "antiquewhite1","aliceblue","antiquewhite3",
                      "white","antiquewhite","wheat" ), 
                 col.table=TRUE),
        MeanLine=list(var=c("lot", "calibration", "day", "int"), 
                      col=c("orange", "blue", "darkgreen", "yellow"), 
                      lwd=c(2,2,2,2)),
        VLine=list(var=c("lot", "day"), col=c("black", "skyblue1"),
                   lwd=c(2, 1), col.table=c(TRUE, TRUE)))

# one can use argument 'JoinLevels' to join factor-levels or a variable
# nested within a higher-level factor, 'VLine' is used to separate levels
# of variables "calibration" and "lot" with different colors
 varPlot(y~calibration/lot/day/run, Data, 
         BG=list(var="calibration", 
                 col=c("#f7fcfd","#e5f5f9","#ccece6","#99d8c9",
                       "#66c2a4","#41ae76","#238b45","#006d2c","#00441b"), 
                 col.table=TRUE), 
         VLine=list(var=c("calibration", "lot"), 
                    col=c("black", "darkgray"), lwd=c(2,1), col.table=TRUE), 
         JoinLevels=list(var="lot", col=c("#ffffb2","orangered","#feb24c"), 
                         lwd=c(2,2,2)), 
         MeanLine=list(var="lot", col="blue", lwd=2))

# same plot demonstrating additional features applicable via 'Points' 
 varPlot(y~calibration/lot/day/run, Data, 
         BG=list(var="calibration", 
                 col=c("#f7fcfd","#e5f5f9","#ccece6","#99d8c9",
                       "#66c2a4","#41ae76","#238b45","#006d2c","#00441b"), 
                 col.table=TRUE), 
         VLine=list(var=c("calibration", "lot"), 
                    col=c("black", "mediumseagreen"), lwd=c(2,1), 
                    col.table=c(TRUE,TRUE)), 
         JoinLevels=list(var="lot", col=c("lightblue", "cyan", "yellow"), 
                         lwd=c(2,2,2)), 
         MeanLine=list(var="lot", col="blue", lwd=2),
         Points=list(pch=list(var="lot", pch=c(21, 22, 24)), 
                     bg =list(var="lot", bg=c("lightblue", "cyan", "yellow")), 
                     cex=1.25))

# depict measurements as boxplots
datS5 <- subset(VCAdata1, sample==5)
varPlot(y~device/day, datS5, Boxplot=list()) 

# present points as jitter-plot around box-center
varPlot(	y~device/day, datS5, 
         Boxplot=list(jitter=1, col.box="darkgreen"),
			BG=list(var="device", col=paste0("gray", c(60, 70, 80)),
					col.table=TRUE),
         Points=list(pch=16, 
						col=list(var="run", col=c("blue", "red"))), 
			Mean=list(col="black", cex=1, lwd=2)) 
legend( "topright", legend=c("run 1", "run 2"),
        fill=c("blue", "red"), box.lty=0, border="white")
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
