% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{vcovVC}
\alias{vcovVC}
\title{Calculate Variance-Covariance Matrix of Variance Components of 'VCA' objects}
\usage{
vcovVC(obj, method = NULL, quiet = FALSE)
}
\arguments{
\item{obj}{(VCA) object}

\item{method}{(character) string, optionally specifying whether to use the algorithm given in the
1st reference ("scm") or in the 2nd refernce ("gb"). If not not supplied, the 
option is used coming with the 'VCA' object.}

\item{quiet}{(logical) TRUE = will suppress any warning, which will be issued otherwise}
}
\value{
(matrix) corresponding to variance-covariance matrix of variance components
}
\description{
This function computes the variance-covariance matrix of variance components (VC) either
applying the approach given in the \eqn{1^{st}}{1st} reference ('method="scm"') or using
the approximation given in the \eqn{2^{nd}}{2nd} reference ('method="gb"').
}
\details{
This function is called on a 'VCA' object, which can be the sole argument. In this case the value
assigned to element 'VarVC.method' of the 'VCA' object will be used.
}
\examples{
\dontrun{
data(realData)
dat1 <- realData[realData$PID==1,]
fit  <- anovaVCA(y~lot/calibration/day/run, dat1) 
vcovVC(fit)
vcovVC(fit, "scm")		# Searle-Casella-McCulloch method (1st reference)
vcovVC(fit, "gb")		# Giesbrecht and Burns method (2nd reference)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com},
Florian Dufey \email{florian.dufey@contractors.roche.com}
}
\references{
Searle, S.R, Casella, G., McCulloch, C.E. (1992), Variance Components, Wiley New York

Giesbrecht, F.G. and Burns, J.C. (1985), Two-Stage Analysis Based on a Mixed Model: Large-Sample
Asymptotic Theory and Small-Sample Simulation Results, Biometrics 41, p. 477-486
}

