% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotUDlist.R
\name{plotUDlist}
\alias{plotUDlist}
\title{Plot UD_list}
\arguments{
\item{x}{output of ppud}

\item{lwd}{line with in plot}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot showing how the result of ppud changes as lambda increases
}
\description{
This function plots how ppud's result changes as lambda increases.
}
\examples{
set.seed(0)
stage1 <- LETTERS[1:3]
stage2 <- LETTERS[1:2]
stage3 <- LETTERS[1:4]
y <- rnorm(3*2*4)
data <- expand.grid(stage1=stage1,
                    stage2=stage2,
                    stage3=stage3)
data <- cbind(data, y)

UD_bal_model_range <- UD_bal_model(data, "y", names(data)[-4], u_range, flist_range)
UD_bal_model_range 

UD_bal_stage_range <- UD_model2stage(UD_bal_model_range)
UD_bal_stage_range 

UD_model_list = ppud(UD_bal_model_range)
plot(UD_model_list)

UD_stage_list = ppud(UD_bal_stage_range)
plot(UD_stage_list)

}
