% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/us_counties.R
\name{us_counties}
\alias{us_counties}
\title{County boundaries (contemporary and historical)}
\usage{
us_counties(map_date = NULL, resolution = c("low", "high"), states = NULL)
}
\arguments{
\item{map_date}{The date of the boundaries as some object coercible to a date
with \code{as.Date()}; the easiest option is a character vector following
the \href{https://en.wikipedia.org/wiki/ISO_8601}{ISO 8601} data format. A
\code{NULL} value will return contemporary boundaries.}

\item{resolution}{The resolution of the map.}

\item{states}{A character vector of state or territory names. Only boundaries
inside these states/territories will be returned. If \code{NULL}, all
boundaries will be returned.}
}
\value{
A SpatialPolygonsDataFrame.
}
\description{
Get the current (2014) boundaries for U.S states, or get historical county
boundaries for dates between 30 December 1636 and 31 December 2000.
}
\examples{
contemporary <- us_counties()
historical   <- us_counties("1820-07-04")
new_england  <- us_counties(states = c("Massachusetts", "Vermont", "Maine",
                                       "New Hampshire", "Rhode Island",
                                       "Connecticut"))
if (require(sp)) {
   plot(contemporary)
   plot(historical)
   plot(new_england)
}

}
\seealso{
For documentation of and citation to the underlying shapefiles for
  contemporary data from the U.S. Census Bureau, see
  \code{\link{census_boundaries}}. For documentation of
  and citation to the underlying shapefiles for contemporary data from the
  U.S. Census Bureau, see \code{\link{hist_us_counties}}.
}

