% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COEF.R
\name{coef.UPG.Probit}
\alias{coef.UPG.Probit}
\title{Extract coefficients from UPG.Probit objects}
\usage{
\method{coef}{UPG.Probit}(object, ..., q = c(0.025, 0.975))
}
\arguments{
\item{object}{an object of class \code{UPG.Probit}.}

\item{...}{other coef parameters.}

\item{q}{a numerical vector of length two holding the posterior quantiles to be extracted. Default are 0.025 and 0.975 quantiles.}
}
\value{
Returns a matrix containing posterior means and the desired credible interval.
}
\description{
\code{coef} can be used to extract posterior means and credible intervals based on posterior quantiles from \code{UPG.Probit} objects.
}
\examples{
\donttest{
# estimate a probit model using example data
library(UPG)
data(lfp)
y = lfp[,1]
X = lfp[,-1]
results.probit = UPG(y = y, X = X, type = "probit", verbose=TRUE)

# extract posterior means and credible interval based on 0.025 and 0.975 quantiles
coef(results.probit, q = c(0.025, 0.975))
}
}
\seealso{
\code{\link{summary.UPG.Probit}} to summarize the estimates of a discrete choice model from an \code{UPG.Probit} object and create tables.
\code{\link{predict.UPG.Probit}} to predict probabilities from a discrete choice model from an \code{UPG.Probit} object.
\code{\link{plot.UPG.Probit}} to plot the results of a discrete choice model from an \code{UPG.Probit} object.
}
\author{
Gregor Zens
}
