% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TETSmodel.R
\name{TETS}
\alias{TETS}
\title{TETS}
\usage{
TETS(
  y,
  u = NULL,
  model = "???",
  s = frequency(y),
  h = 2 * s,
  criterion = "aicc",
  forIntervals = FALSE,
  bootstrap = FALSE,
  nSimul = 5000,
  verbose = FALSE,
  alphaL = c(0, 1),
  betaL = alphaL,
  gammaL = alphaL,
  phiL = c(0.8, 0.98),
  p0 = -99999,
  Ymin = -Inf,
  Ymax = Inf
)
}
\arguments{
\item{y}{a time series to forecast (it may be either a numerical vector or
a time series object). This is the only input required. If a vector, the additional
input \code{s} should be supplied compulsorily (see below).}

\item{u}{a matrix of input time series. If 
the output wanted to be forecast, matrix \code{u} should contain future values for inputs.}

\item{model}{the model to estimate. It is a single string indicating the type of 
model for each component with one or two letters:
\itemize{
\item Error: ? / A

\item Trend: ? / N / A / Ad

\item Seasonal: ? / N / A

}}

\item{s}{seasonal period of time series (1 for annual, 4 for quarterly, ...)}

\item{h}{forecast horizon. If the model includes inputs h is not used, the lenght of u is used instead.}

\item{criterion}{information criterion for identification ("aic", "bic" or "aicc").}

\item{forIntervals}{estimate forecasting intervals (TRUE / FALSE)}

\item{bootstrap}{use bootstrap simulation for predictive distributions}

\item{nSimul}{number of simulation runs for bootstrap simulation of predictive distributions}

\item{verbose}{intermediate estimation output (TRUE / FALSE)}

\item{alphaL}{constraints limits for alpha parameter}

\item{betaL}{constraints limits for beta parameter}

\item{gammaL}{constraints limits for gamma parameter}

\item{phiL}{constraints limits for phi parameter}

\item{p0}{initial values for parameter search (alpha, beta, phi, gamma, sigma2) with consraints:}

\item{Ymin}{scalar or vector of time varying censoring values from below}

\item{Ymax}{scalar or vector of time varying censoring values from above

\itemize{ 
\item 0 < alpha < 1

\item 0 < beta < alpha

\item 0 < phi < 1

\item 0 < gamma < 1 - alpha

\item sigma2 > 0
}}
}
\value{
An object of class \code{TETS}. It is a list with fields including all the inputs and
        the fields listed below as outputs. All the functions in this package fill in
        part of the fields of any \code{TETS} object as specified in what follows (function 
        \code{TETS} fills in all of them at once):

After running \code{TETSforecast}:
\item{p}{Estimated parameters}
\item{criteria}{Values for estimation criteria (LogLik, AIC, BIC, AICc)}
\item{yFor}{Forecasted values of output}
\item{yForV}{Variance of forecasted values of output}
\item{ySimul}{Bootstrap simulations for forecasting distribution evaluation}

After running \code{TETSvalidate}:
\item{table}{Estimation and validation table}
\item{comp}{Estimated components in matrix form}

After running \code{TETScomponents}:
\item{comp}{Estimated components in matrix form}
}
\description{
Runs all relevant functions for TETS modelling
}
\details{
See help of \code{TETSforecast}.
}
\examples{
\donttest{
y <- log(AirPassengers)
m1 <- TETS(y)
m1 <- TETS(y, model = "MAM")
}
}
\seealso{
\code{\link{TETSforecast}}, \code{\link{TETSvalidate}},
         \code{\link{TETScomponents}}
}
\author{
Diego J. Pedregal
}
