% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaHub-class.R
\name{XenaHub}
\alias{XenaHub}
\title{Generate a XenaHub Object}
\usage{
XenaHub(hosts = xena_default_hosts(), cohorts = character(),
  datasets = character(), hostName = c("UCSC_Public", "TCGA", "GDC",
  "ICGC", "Toil", "PanCancer", "Treehouse", "PCAWG"))
}
\arguments{
\item{hosts}{a character vector specify UCSC Xena hosts, all available hosts can be
found by \code{xena_default_hosts()} function. \code{hostName} is a recommend option
for substitute this.}

\item{cohorts}{default is empty character vector, all cohorts will be returned.}

\item{datasets}{default is empty character vector, all datasets will be returned.}

\item{hostName}{one to seven of \code{c("UCSC_Public", "TCGA", "GDC", "ICGC", "Toil", "PanCancer", "Treehouse", "PCAWG")}. This is
a easier option for user than \code{hosts} option. Note, this option will overlap \code{hosts}.}
}
\value{
a \code{XenaHub} object
}
\description{
Major function of \code{UCSCXenatools}. It is used to generate original
\code{XenaHub} object according to hosts, cohorts, datasets or hostName.
If these arguments not specified, all hosts and corresponding datasets
will be returned as a \code{XenaHub} object. All datasets can be found
at <https://xenabrowser.net/datapages/>.
}
\examples{
\donttest{
#1 query all hosts, cohorts and datasets
xe = XenaHub()
xe
#2 query only TCGA hosts
xe = XenaHub(hostName = "TCGA")
xe
hosts(xe)     # get hosts
cohorts(xe)   # get cohorts
datasets(xe)  # get datasets
samples(xe)   # get samples
}
}
\author{
Shixiang Wang <w_shixiang@163.com>
}
