% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{cluster_tweets}
\alias{cluster_tweets}
\title{Cluster tweets on an interactive map}
\usage{
cluster_tweets(data, ...)
}
\arguments{
\item{data}{A data frame of tweets parsed by \link[Twitmo]{load_tweets} or returned by \link[Twitmo]{pool_tweets}.}

\item{...}{Extra arguments passed to \link[leaflet]{markerClusterOptions}}
}
\value{
Interactive leaflet map
}
\description{
Plot into clusters on an interactive map
}
\details{
This function can be used to create interactive maps on OpenStreetView.
}
\examples{

\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

pool <- pool_tweets(mytweets)
cluster_tweets(mytweets)

# OR
cluster_tweets(pool$data)
}

}
\seealso{
\link[leaflet]{tileOptions}
}
