% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTrust.r
\name{ReadTrust}
\alias{ReadTrust}
\title{Read AIRR/TRUST4 report files}
\usage{
ReadTrust(
  airr_file = NULL,
  barcode_report_file = NULL,
  report_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{airr_file}{character. Path to AIRR file.}

\item{barcode_report_file}{character. Path to barcode_report file generated by TRUST4.}

\item{report_file}{character. Path to report file generated by TRUST4.}

\item{verbose}{logical. Print progress. Default is TRUE.}
}
\value{
A VDJ information data.frame
}
\description{
\code{ReadTrust} reads AIRR file and/or barcode_report/report file generated by TRUST4.
Generally
AIRR file: airr.tsv, barcode_airr.tsv (from TRUST4);
barcode_report file: barcode_report.tsv;
report file: report.tsv.
(.gz supported)
\enumerate{
\item AIRR + barcode_report:
\code{ReadTrust} will read AIRR and add it a 'cdr3_germline_similarity' column based on barcode_report.
\item only one file:
\code{ReadTrust} will return a data.frame for this file.
\item AIRR/barcode_report + report:
\code{ReadTrust} will ignore report file when either AIRR or barcode_report file is given.
}
}
\examples{

# file paths
airr_file           = system.file('extdata', 'TRUST4_airr.tsv.gz', package = 'TrustVDJ')
barcode_report_file = system.file('extdata', 'TRUST4_barcode_report.tsv.gz', package = 'TrustVDJ')
report_file         = system.file('extdata', 'TRUST4_report.tsv.gz', package = 'TrustVDJ')

# both AIRR and barcode_report
\donttest{data = ReadTrust(airr_file = airr_file, barcode_report_file = barcode_report_file)
head(data)}

# only AIRR
data = ReadTrust(airr_file = airr_file)
head(data)

# only barcode_report
\donttest{data = ReadTrust(barcode_report_file = barcode_report_file)
head(data)}

# only report
data = ReadTrust(report_file = report_file)
head(data)

}
