#' @name synLFQ8
#'
#' @title Synthetic length-frequency data VIII with variable harvest rate
#' @description Synthetic length-frequency data as generated by the
#'     function \code{virtualPop2} from the \emph{fishdynr} package
#'     (Taylor and Mildenberger, 2018). Can be used by
#'     \code{\link[TropFishR]{ELEFAN}},
#'     \code{\link[TropFishR]{ELEFAN_SA}}, or
#'     \code{\link[TropFishR]{ELEFAN_GA}}.  The data is generated with
#'     the following von Bertalanffy growth parameters: \itemize{
#'     \item K = 0.5 +/- 0.05 (CV) \item Linf = 80 +/- 0.05 (CV) \item
#'     C = 0.0 \item ts = 0.0 \item t_anchor 0.25 (Time when
#'     yearly recruitment pulse occurs; e.g. 0 = Jan 1, 0.25 = Apr 1,
#'     0.5 = Jul 1, 0.75 = Oct 1; repro_wt = c(0, 0, 0, 1, 0, 0, 0, 0,
#'     0, 0, 0, 0)) }
#'
#' Further settings include:
#' \itemize{
#'   \item Lmat.f = 40 (length at maturity)
#'   \item Lmat.m = 36 (length at maturity)
#'   \item L50 = 20 (length at 50\% prob. of capture with trawl net (Lc))
#'   \item wqs = 4 (width between 25\% and 75\% prob. of capture quantiles;
#'   i.e. wqs = 0 is knife-edge selection)
#'   \item M = 0.7 (Natural mortality rate)
#'   \item harvest_rate = 1, 0.8, 0.4, 0.1 for years 2014, 2015, 2016, 2017, repsectively (fishing mortality rate)
#' }
#'
#' The average biomass relative to the unfished biomass and the yield per recurit
#' for the years, 2014, 2015, 2016, 2017 is
#' 0.16, 0.21, 0.41, 0.75, and 0.4, 0.43, 0.24, 0.07, respectively. Biomass over
#' Bmsy as estimated with a surplus production model is 0.51, 0.67, 1.27, 2.18. Lopt is
#' 53.33 cm.
#'
#' @docType data
#'
#' @format A list of class lfq consisting of:
#' \itemize{
#'  \item \strong{stock} Stock ID or name,
#'   \item \strong{dates} dates of sampling times (class Date),
#'   \item \strong{midLengths} midpoints of the length classes,
#'   \item \strong{catch} matrix with catches/counts per length class (row) and
#'      sampling date (column),
#'   \item \strong{comment} additional comments to this data set.
#' }
#'
#' @source Taylor, M & T. K. Mildenberger  (2018). fishdynr: Fisheries science related population dynamics
#' models. R package version 0.5. https://github.com/tokami/fishdynr
#'
#' @usage data(synLFQ8)
#' @keywords data dataset length-frequency
#'
#' @examples
#' data(synLFQ8)
#'
#' # plot of length frequencies
#' plot(synLFQ8, Fname = "catch")
#'
#' # plot of restructured length frequencies
#' synLFQ8 <- lfqRestructure(synLFQ8, MA = 11)
#' plot(synLFQ8, Fname = "rcounts")
#'
#'
#'
NULL
