% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{DropTip}
\alias{DropTip}
\alias{DropTip.phylo}
\alias{DropTipPhylo}
\alias{DropTip.multiPhylo}
\alias{KeepTip}
\title{Drop tips from tree}
\usage{
DropTip(tree, tip, preorder = TRUE, check = TRUE)

\method{DropTip}{phylo}(tree, tip, preorder = TRUE, check = TRUE)

DropTipPhylo(tree, tip, preorder = TRUE, check = TRUE)

\method{DropTip}{multiPhylo}(tree, tip, preorder = TRUE, check = TRUE)

KeepTip(tree, tip, preorder = TRUE, check = TRUE)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{tip}{Character vector specifying labels of leaves in tree to be dropped,
or integer vector specifying the indices of leaves to be dropped.
Specifying the index of an internal node will drop all descendants of that
node.}

\item{preorder}{Logical specifying whether to \link{Preorder} the tree before
dropping tips.  Necessary if a tree's edges may be unconventionally numbered.}

\item{check}{Logical specifying whether to check validity of \code{tip}. If
\code{FALSE} and \code{tip} contains entries that do not correspond to leaves of the
tree, undefined behaviour may occur.}
}
\value{
\code{DropTip()} returns a tree of class \code{phylo}, with the requested
leaves removed.

\code{KeepTip()} returns \code{tree} with all leaves not in \code{tip} removed,
in preorder.
}
\description{
\code{DropTip()} removes specified tips from a phylogenetic tree, collapsing
incident branches.
}
\details{
This function is more robust than \code{\link[ape:drop.tip]{ape::drop.tip()}} as it does not
require any particular internal node numbering schema.
}
\section{Functions}{
\itemize{
\item \code{DropTipPhylo}: Direct call to \code{DropTip.phylo()}, to avoid overhead of
querying object's class.
}}

\examples{
tree <- BalancedTree(8)
plot(tree)
plot(DropTip(tree, c('t4', 't5')))

}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
