% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tlsPlot}
\alias{tlsPlot}
\title{Plot TLS outputs}
\usage{
tlsPlot(las, sgmt = NULL, map = NULL, treeID = NULL,
  sgmtColor = "yellow")
}
\arguments{
\item{las}{\code{LAS} object - ideally an output from \code{\link{stemPoints}}.}

\item{sgmt}{optional \code{data.table} - output from \code{\link{stemSegmentation}}.}

\item{map}{optional \code{LAS} object - output from \code{\link{treeMap}}.}

\item{treeID}{optional \code{numeric} - single \emph{TreeID} to extract from \code{las}.}

\item{sgmtColor}{optional - color of the plotted stem segment representations.}
}
\description{
Plot the \code{LAS} outputs of tls functions on the same scene using \code{rgl}. Check ?stemSegmentation
for usage examples.
}
\examples{
### single tree
file = system.file("extdata", "spruce.laz", package="TreeLS")
tls = readTLS(file)
tls = stemPoints(tls)
df = stemSegmentation(tls)

tlsPlot(tls, df)

### For further examples check:
?stemSegmentation
}
