% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_utilities.R
\name{CalculateTreeDistance}
\alias{CalculateTreeDistance}
\title{Wrapper for tree distance calculations}
\usage{
CalculateTreeDistance(Func, tree1, tree2 = NULL, reportMatching = FALSE, ...)
}
\arguments{
\item{Func}{Tree distance function.}

\item{tree1}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on Day (1985).}

\item{tree2}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on Day (1985).}

\item{reportMatching}{Logical specifying whether to return the clade
matchings as an attribute of the score.}

\item{\dots}{Additional arguments to \code{Func}.}
}
\description{
Calls tree distance functions from trees or lists of trees
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
