% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_dim.R
\name{empirical.distributions}
\alias{empirical.distributions}
\title{Empirical Null Distribution of Tree Dimension Test}
\usage{
empirical.distributions(rows, cols, perm = 100, MST = c("boruvka", "exact"))
}
\arguments{
\item{rows}{number of rows for data representing null case. Rows
represent sample size.}

\item{cols}{number of columns for data representing null case.
Columns represent variables.}

\item{perm}{number of simulations to compute null distribution.
Default is 100.}

\item{MST}{name of MST to be used in computing distribution. There
are two options; "exact" MST and "boruvka" which is faster for
large samples}
}
\value{
A list with the following components:
\itemize{
 \item dist       A vector with null distribution of s statistic
 \item meanlog    The meanlog parameter estimation for the lognormal distribution on empirical null distribution S.
 \item sdlog      The sdlog parameter estimation for lognormal distribution on empirical null distribution of S.
}
}
\description{
Computes empirical null distribution of S statistic and parameters
 for lognormal approximation for input of size rows * columns using
 multivariate normal randomization
}
