% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParameters.R
\name{plotParam}
\alias{plotParam}
\title{Plot Parameter Estimates}
\usage{
plotParam(x, includeIndividual = TRUE, addLines = FALSE,
  estimate = "mean", select = "all", ...)
}
\arguments{
\item{x}{a fitted Beta or latent-trait MPT model}

\item{includeIndividual}{whether to plot individual estimates}

\item{addLines}{whether to connect individual parameter estimates by lines}

\item{estimate}{type of point estimates for group-level and individual parameters (either \code{"mean"} or \code{"median"})}

\item{select}{character vector of parameters to be plotted (e.g., \code{select = c("d", "g")}. Can be used to plot subsets of parameters and change the order of parameters.}

\item{...}{further arguments passed to the standard \code{\link{plot}} function}
}
\description{
Plot parameter estimates for hierarchical MPT models.
}
\examples{
\dontrun{
plotParam(fit, addLines = TRUE,
          estimate = "median",
          select = c("d1", "d2"))
}
}
\seealso{
\code{\link{betaMPT}}, \code{\link{traitMPT}}, \code{\link{plotDistribution}}
}
\author{
Daniel Heck
}
