% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitSimpleMPT.R
\name{simpleMPT}
\alias{simpleMPT}
\title{C++ Sampler for Standard MPT Model}
\usage{
simpleMPT(eqnfile, data, restrictions, n.iter = 20000, n.burnin = 2000,
  n.thin = 5, n.chains = 3, ppp = 0, alpha = 1, beta = 1, parEstFile)
}
\arguments{
\item{eqnfile}{The (full path to the) file that specifies the MPT model (standard .eqn syntax). Note that category labels must start with a letter (different to multiTree) and match the column names of \code{data}}

\item{data}{The (full path to the) csv file with the data (comma separated; category labels in first row). Alternatively: a data frame or matrix (rows=individuals, columns = individual category frequencies, category labels as column names)}

\item{restrictions}{Specifies which parameters should be (a) constant (e.g., \code{"a=b=.5"}) or (b) constrained to be identical (e.g., \code{"Do=Dn"}) or (c) treated as fixed effects (i.e., identical for all participants; \code{"a=b=FE"}). Either given as the path to a text file with restrictions per row or as a list of restrictions, e.g., \code{list("D1=D2","g=0.5")}}

\item{n.iter}{Number of iterations per chain (including burnin samples). See \code{\link[runjags]{run.jags}} for details.}

\item{n.burnin}{Number of samples for burnin (samples will not be stored and removed from n.iter)}

\item{n.thin}{Thinning rate.}

\item{n.chains}{number of MCMC chains (sampled in parallel).}

\item{ppp}{number of samples to compute  posterior predictive p-value (see \code{\link{posteriorPredictive}})}

\item{alpha}{first shape parameter(s) for the beta prior-distribution of the MPT parameters \eqn{\theta_s} (can be a named vector to use a different prior for each MPT parameter)}

\item{beta}{second shape parameter(s)}

\item{parEstFile}{Name of the file to with the estimates should be stored (e.g., "parEstFile.txt")}
}
\description{
Fast Gibbs sampler in C++ that is tailored to the standard MPT model (i.e., non-hierarchical MPT: assumes separate parameters if multiple data sets are supplied).
}
\details{
Beta distributions with fixed shape parameters \eqn{\alpha} and \eqn{\beta} are used. The default \eqn{\alpha=1} and \eqn{\beta=1} assumes uniform priors for all MPT parameters.
}
\author{
Daniel Heck
}

