% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSunburstPlot.R
\name{createSunburstPlot2}
\alias{createSunburstPlot2}
\title{createSunburstPlot2}
\usage{
createSunburstPlot2(
  treatmentPathways,
  groupCombinations = FALSE,
  colors = NULL
)
}
\arguments{
\item{treatmentPathways}{(\code{data.frame()})\cr
The contents of the treatmentPathways.csv-file as a data.frame().}

\item{groupCombinations}{(\code{logical(1)}: \code{FALSE})\cr
\describe{
\item{\code{TRUE}}{Group all combination treatments in category \code{"Combination"}.}
\item{\code{FALSE}}{Do not group combination treatments.}
}}

\item{colors}{(\code{character(n)}) Vector of hex colors codes.}
}
\value{
(\code{htmlwidget})
}
\description{
New sunburstPlot function
}
\examples{
# Dummy data, typically read from treatmentPathways.csv
treatmentPatwhays <- data.frame(
  path = c("Acetaminophen", "Acetaminophen-Amoxicillin+Clavulanate",
           "Acetaminophen-Aspirin", "Amoxicillin+Clavulanate", "Aspirin"),
  freq = c(206, 6, 14, 48, 221),
  sex = rep("all", 5),
  age = rep("all", 5),
  index_year = rep("all", 5)
)

createSunburstPlot2(treatmentPatwhays)
}
