% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dic.ad.R
\name{dic.ad}
\alias{dic.ad}
\title{Analise de experimento  conduzido no delineamento inteiramente casualizado
com testemunhas adicionais}
\usage{
dic.ad(Dados,alfa=0.05,quali=TRUE,verbose=TRUE)
}
\arguments{
\item{Dados}{Matriz contendo na primeira coluna a identificacao dos
tratamentos testemunhas (tratamentos comuns deve ter valor zero ou NA). A
segunda coluna deve ter a identificacao de todos os tratamentos.  A
terceira coluna a identificacao das repeticoes. Na quarta coluna os
resultados experimentais.}

\item{alfa}{valor indicando o nivel de significancia. Deve ser
obrigatoriamente "0.001", "0.01", "0.05" ou "0.10" (default = 0.05).}

\item{quali}{Valor logico (TRUE/FALSE). TRUE indica que o Tratamento e
qualitativo, realizando-se o teste de medias. FALSE indica que o fator e
quantitativo, sendo feita a analise de regressao.}

\item{verbose}{Valor logico (TRUE/FALSE). TRUE apresenta os resultados da analise.}
}
\value{
Retorna a comparacao multipla de medias obtida por varios testes.
}
\description{
Esta funcao retorna a comparacao multipla de medias (obtidas
 pelos testes t, t com protecao de Bonferroni, Duncan, Dunnet, SNK, Tukey e
 Scott-Knott) se os tratamentos for qualitativos. Ou a analise de regressao
 se os tratamentos forem quantitativos. Para comparar a testemunha adicional
 com os demais e utilizado o teste Dunnet. Esta funcao considera o
 delineamento inteiramente casualizado. "This function returns the multiple
 comparison tests (t, t tests with Bonferroni protection, Duncan, Dunnet,
 SNK, Tukey and Scott-Knott ) if the treatments are qualitative. Or
 regression analysis if treatments are quantitative. To compare the
 additional control with the others treatments, the Dunnet test is used. This
 function considers the completely randomized design."
}
\examples{
 ######
 #Exemplo de um experimento em DIC com tratamentos qualitativos e uma
 #testemunha adicional
 data(Dados1)
 dic.ad(Dados = Dados1,alfa = 0.05,quali =TRUE)
 #Exemplo de um experimento em DIC com tratamentos quantitativos e tres
 #testemunhas adicionais
data(Dados2)
dic.ad(Dados = Dados2,alfa = 0.05,quali =FALSE)
}
\references{
BANZATTO, D. A.; KRONKA, S. N. Experimentacao
Agricola. 4 ed. Jaboticabal: Funep. 2006. 237 p.

GOMES, F. P. Curso de Estatistica Experimental.
10a ed. Piracicaba: ESALQ/USP. 1982. 430.
}
