% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichCircoBar.R
\name{extract_descriptions_counts}
\alias{extract_descriptions_counts}
\title{Extract and Count Descriptions with Specified Color}
\usage{
extract_descriptions_counts(df, descriptions, color)
}
\arguments{
\item{df}{A data frame containing at least 'Description' and 'Count' columns.}

\item{descriptions}{A vector of descriptions to filter in the data frame.}

\item{color}{A character string specifying the color to be added as a new column.}
}
\value{
A data frame filtered by descriptions, containing 'Description', 'Count', and a new 'color' column.
}
\description{
This function filters a data frame for specified descriptions, selects the 'Description' and 'Count' columns,
and adds a new column with a specified color.
}
\examples{
# Generate Sample Input Data for extract_descriptions_counts Function

# Create a sample data frame with 'Description' and 'Count' columns
data <- data.frame(
  Description = c(
    "immunoglobulin production",
    "B cell mediated immunity",
    "T cell activation",
    "antigen processing and presentation",
    "cytokine signaling",
    "natural killer cell activity",
    "phagocytosis",
    "complement activation",
    "antibody-dependent cellular cytotoxicity",
    "regulatory T cell function"
  ),
  Count = c(
    150,  # immunoglobulin production
    200,  # B cell mediated immunity
    175,  # T cell activation
    125,  # antigen processing and presentation
    190,  # cytokine signaling
    160,  # natural killer cell activity
    140,  # phagocytosis
    180,  # complement activation
    130,  # antibody-dependent cellular cytotoxicity
    170   # regulatory T cell function
  ),
  stringsAsFactors = FALSE  # Ensure that strings are not converted to factors
)



descriptions_to_filter <- c("immunoglobulin production", "B cell mediated immunity")
specified_color <- "red"  # You can specify any color you desire
filtered_data_with_color <- extract_descriptions_counts(
  data, descriptions_to_filter,
  specified_color)
print(filtered_data_with_color)

}
