% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roulette_pl_calculator_specific_number.R
\name{roulette_pl_calculator_specific_number}
\alias{roulette_pl_calculator_specific_number}
\title{Roulette P&L betting on a specific number}
\usage{
roulette_pl_calculator_specific_number(
  bet_minimum,
  bet_maximum,
  initial_capital,
  targeted_number,
  simulations_num,
  trials_per_sim,
  stop_loss
)
}
\arguments{
\item{bet_minimum}{The minimum betting amount that the casino allows}

\item{bet_maximum}{The maximum betting amount that the casino allows}

\item{initial_capital}{The initial capital to be used}

\item{targeted_number}{The specific number that we expect to be drawn (statistically speaking, this should have zero effect on the results)}

\item{simulations_num}{The number of simulations to be run}

\item{trials_per_sim}{The number of trials in each simulation}

\item{stop_loss}{(Optional) The number of spins after which the betting amount will go back to the minimum if the targeted number hasn't appeared.}
}
\value{
A list containing the minimum, the maximum and the final balance for each simulation. Also the P&L graph for the last simulation will be plotted.
}
\description{
Calculates the potential profit or loss when someone is betting on a specific number in the roulette and keeps doubling every eighteen 
spins if the number hasn't appeared yet.
}
\examples{

# This software is covered by GPL license and provided strictly for educational 
# reasons (no actual investment or betting decisions should be taken based on this)
# On top of these, the below example contains a tiny number of simulations and
# trials just to pass CRAN tests - the user would have to highly increase both
# variables when running these.
pl_results = roulette_pl_calculator_specific_number(bet_minimum =0.1 , bet_maximum = 3276.8,
initial_capital = 20000, targeted_number = 0, simulations_num = 100, 
trials_per_sim = 100, stop_loss = 180)
summary(pl_results$min_capital)
summary(pl_results$max_capital)
summary(pl_results$final_capital)

}
\references{
https://en.wikipedia.org/wiki/Roulette#Betting_strategies_and_tactics
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
