% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_bindings.R
\name{get_precision_on}
\alias{get_precision_on}
\alias{set_precision_on}
\title{Set or return precision_on layer binding}
\usage{
get_precision_on(layer)

set_precision_on(layer, precision_on)
}
\arguments{
\item{layer}{A \code{tplyr_layer} object}

\item{precision_on}{A string, a variable name, or a list of variable names
supplied using \code{dplyr::vars}.}
}
\value{
For \code{get_precision_on}, the precision_on binding of the supplied
  layer. For \code{set_precision_on} the modified layer environment.
}
\description{
The precision_on variable is the variable used to establish numeric
precision. This variable must be included in the list of \code{target_var}
variables.
}
\examples{
# Load in pipe
library(magrittr)
lay <- tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_desc(vars(mpg, disp), by=vars(carb, am)) \%>\%
    set_precision_on(disp)
  )
}
