% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_bindings.R
\name{get_precision_by}
\alias{get_precision_by}
\alias{set_precision_by}
\title{Set or return precision_by layer binding}
\usage{
get_precision_by(layer)

set_precision_by(layer, precision_by)
}
\arguments{
\item{layer}{A \code{tplyr_layer} object}

\item{precision_by}{A string, a variable name, or a list of variable names supplied
using \code{dplyr::vars}.}
}
\value{
For \code{get_precision_by}, the precision_by binding of the supplied
  layer. For \code{set_precision_by} the modified layer environment.
}
\description{
The precision_by variables are used to collect the integer and decimal
precision when auto-precision is used. These by variables are used to group
the input data and identify the maximum precision available within the
dataset for each by group. The precision_by variables must be a subset of the
by variables
}
\examples{
# Load in pipe
library(magrittr)
lay <- tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_desc(mpg, by=vars(carb, am)) \%>\%
    set_precision_by(carb)
  )
}
