% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat2df.R
\name{mat2df}
\alias{mat2df}
\title{Matrix to pairwise data frame}
\usage{
mat2df(M)
}
\arguments{
\item{M}{a square pairwise matrix (e.g., of distances).}
}
\value{
Data frame with pairwise distances.
}
\description{
Turns a distance matrix into a data frame of pairwise distances.
}
\examples{
set.seed(42)
M <- matrix(rnorm(25), nrow=5)
M
mat2df(M)
M <- matrix(rnorm(25), nrow=5, dimnames=list(letters[1:5], letters[1:5]))
M
mat2df(M)
  
}
\author{
Stephen Turner
}
