% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tileScheme.R
\name{tileScheme}
\alias{tileScheme}
\title{Tile Scheme}
\usage{
tileScheme(
  input,
  tiledim,
  cells = FALSE,
  buffer = 0,
  bufferspill = FALSE,
  round = NA,
  roundDir = "out",
  crs = NULL,
  origin = NULL,
  removeEmpty = FALSE
)
}
\arguments{
\item{input}{filename (character), Extent, Raster or a vector of four numbers}

\item{tiledim}{numeric. Defines the 'x' and 'y' dimensions of each tile. By default, dimensions are in map
units. If `cells` is set to TRUE, then dimensions are in number of cells}

\item{cells}{logical. If set to TRUE, \code{tiledim} and \code{buffer} dimensions will be in number of cells instead of
map units}

\item{buffer}{numeric. If set to >0, overlapping buffers will be created around each tile}

\item{bufferspill}{logical. Default is \code{FALSE}, in which case the tiling grid will be pushed inwards so that the
buffers of the outer tiles are within the extent of \code{input}. If set to \code{TRUE}, the buffers will extend outside
of the extent of \code{input}}

\item{round}{numeric. Round the extent of the input Extent to the number of digits specified here.}

\item{roundDir}{character. The direction of the rounding, either \code{in} for inwards or \code{out} for outwards.}

\item{crs}{character. PROJ4 string defining output coordinate reference system (CRS). If set to NULL, the function will attempt to get
a CRS from \code{input} (only works if it is a raster). Set to NA to force the output to have no CRS.}

\item{origin}{numeric. Optional vector of two numbers corresponding to a pair of coordinates to which the tiling scheme will
be aligned. Cannot be used in conjunction with \code{cells}. The coordinates do not need to be within the extent of
\code{input}}

\item{removeEmpty}{logical. Default is \code{FALSE}. If set to \code{TRUE}, tiles containing only \code{NA} cell values
will be removed from the tiling scheme. Can only be used when \code{input} is a Raster object.}
}
\value{
a 'tileScheme' object
}
\description{
This function aims to provide an all-in-one tool for creating tiling schemes, which includes options for overlapping
buffers and methods for describing tile sizes in various ways (i.e. using either distance units or cell numbers).
}
\section{Non-overlapping buffers}{


When processing a tiled dataset, using buffered tiles can help remove the edge effects along the
individual tile borders. However, overlapping buffers generally need to be removed when recombining
a series of tiles back into a single raster. Although this can be accomplished by using the unbuffered
tile extent, this will also remove the buffered areas along the edge of the tile set. Once these
unbuffered tiles are reassembled, the resulting raster will then be smaller than the original
dataset before it was tiled.

This may not be a desirable result. The polygons located in the \code{nbuffs} slot will produce a set of
polygons that correspond to the tile extents that conserve buffers only where they do not overlap onto
neighboring tiles (i.e.: along the edge of the tile set). These polygons are useful for cropping out
overlapping areas from buffered tiles in order to reassemble the tiles into a single raster.
}

\examples{
\dontrun{
ts1 <- tileScheme(CHMdemo, tiledim = c(50,50))

ts2 <- tileScheme(CHMdemo, tiledim = c(100,120), cells = TRUE)

ts3 <- tileScheme(CHMdemo, tiledim = 40, buffer = 5, origin = c(0.5, 0.5))
}
}
