% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-uniform.R
\name{util_uniform_aic}
\alias{util_uniform_aic}
\title{Calculate Akaike Information Criterion (AIC) for Uniform Distribution}
\usage{
util_uniform_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a uniform distribution.}
}
\value{
The AIC value calculated based on the fitted uniform distribution to the provided data.
}
\description{
This function estimates the min and max parameters of a uniform distribution
from the provided data and then calculates the AIC value based on the fitted
distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a uniform
distribution fitted to the provided data.

This function fits a uniform distribution to the provided data. It estimates
the min and max parameters of the uniform distribution from the range of the data.
Then, it calculates the AIC value based on the fitted distribution.

Initial parameter estimates: The function uses the minimum and maximum values
of the data as starting points for the min and max parameters of the uniform
distribution.

Optimization method: Since the parameters are directly calculated from the
data, no optimization is needed.

Goodness-of-fit: While AIC is a useful metric for model comparison,
it's recommended to also assess the goodness-of-fit of the chosen
model using visualization and other statistical tests.
}
\examples{
# Example 1: Calculate AIC for a sample dataset
set.seed(123)
x <- runif(30)
util_uniform_aic(x)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_weibull_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
