\name{LimitSell}
\alias{LimitSell}
\title{Execute Limit Sell Order}
\description{
(Try) to sell a given instrument at given date and time slot, by limit order. 
If limit price was not given, then use the last trading price as limit price. 
If both 'orderTo' and 'orderLast' was given, then the smaller one will be adopted.
}
\usage{
LimitSell(dir = dir, date, dfLog, limitPrice = NA, orderFrom, orderTo = 150000, 
          orderLast = 7 * 3600, costOut = 0.001) 
}
\arguments{
  \item{dir}{The directory containing the Tick data.}
  \item{date}{the date for placing the order.}
  \item{dfLog}{The dataframe generated by buy-orders.}
  \item{limitPrice}{the limit price to sell.}
  \item{orderFrom}{time of the order being placed.}
  \item{orderTo}{time of the order being withdrawed.}
  \item{orderLast}{duration of the order, in seconds.}
  \item{costOut}{transaction cost for selling.}
}
\value{
The same dataframe dfLog, with corresponding entries updated.
}
\examples{
## locate tick data directory ##
dir <- system.file("extdata", '', package = "TickExec")

## establish a posiyion to sell ##
dfLog = LimitBuy(dir = dir, date = 20141013, ticker = 000001, capital = 1e6, 
                 limitPrice = NA, orderFrom = 94545, orderLast = 600, 
                 costIn = 0.001)

## sell ##
dfLogSold = LimitSell(dir = dir, date = 20141013, dfLog = dfLog, limitPrice = 10.1, 
                      orderFrom = 142020, orderTo = 150000, costOut = 0.001) 
                       
## see result ##
dfLogSold
}
\keyword{limit sell order}