% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{loadConstraints}
\alias{loadConstraints}
\title{Load constraints}
\usage{
loadConstraints(file, pool, item_attrib, st_attrib = NULL)
}
\arguments{
\item{file}{Character. The name of the file containing specifications for constraints.}

\item{pool}{An \code{item_pool} object.}

\item{item_attrib}{An \code{item_attrib} object containing item attributes. Use \code{\link{loadItemAttrib}} for this.}

\item{st_attrib}{(Optional) An \code{st_attrib} object containing stimulus attributes. Use \code{\link{loadStAttrib}} for this.}
}
\value{
A list containing the parsed constraints, to be used in \code{\link{Static}} and \code{\link{Shadow}}.
}
\description{
Read constraints from specified file.
}
\details{
Use \code{vignette("constraints")} for instructions on how to create the constraint file.
}
\examples{
## Write to tempdir() and clean afterwards
f <- file.path(tempdir(), "itempool_science.csv")
write.csv(itempool_science_raw, f, row.names = FALSE)
itempool_science <- loadItemPool(f)
file.remove(f)

f <- file.path(tempdir(), "itemattrib_science.csv")
write.csv(itemattrib_science_raw, f, row.names = FALSE)
itemattrib_science <- loadItemAttrib(f, itempool_science)
file.remove(f)

f <- file.path(tempdir(), "constraints_science.csv")
write.csv(constraints_science_raw, f, row.names = FALSE)
constraints_science <- loadConstraints(f,
  itempool_science, itemattrib_science)
file.remove(f)

}
\seealso{
\link{dataset_science} for example usage.
}
