% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iter_proj.R
\name{iter_proj}
\alias{iter_proj}
\title{Iterative Projection Estimator.}
\usage{
iter_proj(X, initial_direction, proj_N = 30, z = rep(1, length(X@modes) - 1))
}
\arguments{
\item{X}{A 'Tensor' object defined in package \pkg{rTensor} with \eqn{K+1} modes. Mode-1 should correspond to the time mode.}

\item{initial_direction}{Initial direction for projection, written in a list of \eqn{K} vectors. This can be obtained from the pre-averaging procedure.}

\item{proj_N}{Number of iterations, should be a positive integer. Default is 30.}

\item{z}{(Estimated) Rank of the core tensor, written as a vector of length \eqn{K}. Can be set as 1's when we only need to do rank estimation based on projected data. Default is 1's.}
}
\value{
A list of \eqn{K} estimated factor loading matrices.
}
\description{
Function for Iterative Projection to re-estimate the factor loading matrices.
}
\details{
Input a tensor time series and initial projection direction, return the estimated factor loading matrices using iterative projection.
}
\examples{
# Example of a real data set
set.seed(10)
Q_PRE = pre_est(value_weight_tensor)
Q_PROJ = iter_proj(value_weight_tensor, initial_direction = Q_PRE)
Q_PROJ

set.seed(10)
Q_PRE = pre_est(value_weight_tensor)
Q_PROJ_2 = iter_proj(value_weight_tensor, initial_direction = Q_PRE, z = c(2,2))
Q_PROJ_2

\donttest{
# Example using generated data
K = 2
T = 100
d = c(40,40)
r = c(2,2)
re = 10
eta = list(c(0,0),c(0,0))
u = list(c(-2,2),c(-2,2))
set.seed(10)
Data_test = tensor_data_gen(K,T,d,r,re,eta,u)
X = Data_test$X
Q_PRE = pre_est(X)
Q_PROJ = iter_proj(X, initial_direction = Q_PRE, z = r)
Q_PROJ
}
}
