% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMST.R
\name{paraRMST}
\alias{paraRMST}
\title{Restricted Mean Survival Time}
\usage{
paraRMST(fit, sig = 0.05, tau)
}
\arguments{
\item{fit}{Fitted parametric survival distribution.}

\item{sig}{Significance level, for CIs.}

\item{tau}{Numeric vector of truncation times.}
}
\value{
Data.table containing the estimated RMST at each truncation time.
}
\description{
Calculates the tau-year RMST for a fitted parametric model.
}
\examples{
# Generate Weibull data with 20\% censoring.
data = genData(n=1e3,dist="weibull",theta=c(2,0.5),p=0.2);
fit = fitParaSurv(time=data$time,status=data$status,dist="weibull");
rmst = paraRMST(fit=fit,tau=c(0.5,1.0,1.5,2.0));

# Generate Gamma data with 10\% censoring.
data = genData(n=1e3,dist="gamma",theta=c(2,2),p=0.10);
fit = fitParaSurv(time=data$time,status=data$status,dist="gamma");
rmst = paraRMST(fit=fit,tau=c(0.5,1.0,1.5,2.0));
}
