% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.r
\name{predict}
\alias{predict}
\alias{predict.MLM}
\alias{predict.linear}
\title{Predict method for \code{\link{modeling}} objects}
\usage{
\method{predict}{MLM}(object, mdl, data, n.ahead, ..., onestep = TRUE)

\method{predict}{linear}(object, mdl, data, n.ahead, ..., onestep = TRUE)
}
\arguments{
\item{object}{An object of class \code{\link{modeling}} defining a particular model.}

\item{mdl}{A time series model object used for prediction.}

\item{data}{A list of time series data input for prediction.}

\item{n.ahead}{Integer defining the number of observations to be predicted.}

\item{...}{Other parameters passed to \code{pred_func} of \code{object}.}

\item{onestep}{Should the function produce one-step ahead predictions?
If \code{FALSE}, a multi-step ahead prediction approach is adopted.

For \code{predict.MLM}, \code{sw} of \code{object} may be used to transform the time series 
input in \code{data} into sliding windows used during prediction. Also, 
\code{proc} of \code{object} may be used to preprocess/postprocess the input during prediction.}
}
\value{
A list containing \code{object} and the produced predictions.
}
\description{
Obtains time series predictions based on a trained model and a particular prediction function
defined in a \code{\link{modeling}} object.
}
\examples{
data(CATS,CATS.cont)

a <- ARIMA()
model <- train(a,list(CATS[,1]))$results[[1]]$res
pred_data <- predict(a,model,data=NULL,n.ahead=20,onestep=FALSE)

n <- NNET(size=5, sw=SW(window_len = 5+1), proc=list(MM=MinMax()))
model <- train(n,list(CATS[,1]))$results[[1]]$res
pred_data <- predict(n,model,data=list(CATS.cont[,1]),n.ahead=20)

}
\seealso{
Other predict: 
\code{\link{predict.tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{predict}
\keyword{prediction}
\keyword{series}
\keyword{time}
