% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arimaparameters.R
\name{arimaparameters}
\alias{arimaparameters}
\title{Get ARIMA model parameters}
\usage{
arimaparameters(fit)
}
\arguments{
\item{fit}{An object of class "Arima" containing a fitted ARIMA model.}
}
\value{
A list giving the number of AR, MA, seasonal AR and seasonal MA
coefficients, plus the period and the number of non-seasonal and seasonal
differences of the provided ARIMA model. The value of the fitted drift
constant is also presented.
}
\description{
The function returns the parameters of a fitted ARIMA model, including
non-seasonal and seasonal orders and drift.
}
\details{
The \code{fit} object could possibly be the result of
\code{\link[forecast]{auto.arima}} or \code{\link[forecast]{Arima}} of the
\code{forecast} package, or \code{\link[stats]{arima}} of the \code{stats}
package.
}
\examples{

data(SantaFe.A)
arimaparameters(forecast::auto.arima(SantaFe.A[,1]))

}
\references{
R.J. Hyndman and G. Athanasopoulos, 2013, Forecasting:
principles and practice. OTexts.

R.H. Shumway and D.S. Stoffer, 2010, Time Series Analysis and Its
Applications: With R Examples. 3rd ed. 2011 edition ed. New York, Springer.
}
\seealso{
\code{\link{fittestArima}},\code{\link{arimapred}}
}
\author{
Rebecca Pontes Salles
}
\keyword{ARIMA}
\keyword{parameters}
