% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discriminant.R
\name{classify.MultiWaveAnalysis}
\alias{classify.MultiWaveAnalysis}
\title{Classifies observations based on a pretrained model.}
\usage{
\method{classify}{MultiWaveAnalysis}(data, model, ...)
}
\arguments{
\item{data}{Data to be classified by the model. Remember that it must be an
object of type MultiWaveAnalysis. Note that it should have the same
variables selected as those used to generate the model.}

\item{model}{pretrained discriminant model (lda or qda)}

\item{...}{Additional arguments}
}
\value{
A factor with predicted class of each observation
}
\description{
This function allows to classify observations based on a pretrained model
that could have been obtained in several ways (such as using the train model
function).
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
# We simulate that the second series has been obtained after
Series1 <- ECGExample[, , 1:9]
Series2 <- ECGExample[, , 10, drop = FALSE]

# Training a discriminant model
MWA <- MultiWaveAnalysis(Series1, "haar", features = c("var"))
MWADiscrim <- StepDiscrim(MWA, c(rep(1, 5), rep(2, 4)), maxvars = 5,
                          features = c("var"))
model <- trainModel(MWADiscrim, c(rep(1, 5), rep(2, 4)), "linear")

# Using the discriminant trained on new data
MWA2 <- MultiWaveAnalysis(Series2, "haar", features = c("var"))
MWA2Discrim <- SameDiscrim(MWA2, MWADiscrim)
prediction <- classify(MWA2Discrim, model)
}

}
\seealso{
\itemize{
\item \code{\link{trainModel}}
}
}
