% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxFuncts.R
\name{testFilters}
\alias{testFilters}
\title{testFilters}
\usage{
testFilters(
  XSeries,
  grps,
  maxvars,
  filters = c("haar", "d4", "d6", "d8", "la8"),
  features = c("Var", "Cor", "IQR", "PE", "DM"),
  lev = 0
)
}
\arguments{
\item{XSeries}{Samples from the population (dim x length x cases)}

\item{grps}{Labeled vector that classify the observations.}

\item{maxvars}{maximum number of variables included by the StepDiscrim
algorithm. Must be grater than 0 and, in normal cases, lesser than 100}

\item{filters}{Vector indicating the filters to be tested. To see the
available filters use the function \code{\link{availableFilters}}}

\item{features}{A list of characteristics that will be used for the
classification process. To see the available features see
\code{\link{availableFeatures}}}

\item{lev}{Wavelet decomposition level, by default is selected using the
"conservative" strategy. See \code{\link{chooseLevel}} function.}
}
\value{
A list that each element contains:
\itemize{
\item CM: confusion matrix with a particular configuration using LOOCV
\item Classification: a vector with the raw classification result. "1" if the
observation belongs to the population 1 and "2" if
belongs to the population 2.
\item NVars: the total numbers of variables have been taken into account in the
classification process
\item Method: type of classifier used.
\item Filter: filter used in the MultiWave analysis process
\item Features: vector containing the features taken into account
}
}
\description{
This function performs a test with a series of filters defined by the user,
for the maximum number of variables determined. This function can be used to
compare the performance of different filters with a different number of
variables to be considered and the differences between a linear and a
quadratic discriminant.
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
# The dataset has the first 5 elements of class 1
# and the last 5 of class 2.
grps <- c(rep(1, 5), rep(2, 5))
result <- testFilters(ECGExample, grps, features=c("var","cor"),
          filters= c("haar","d4"), maxvars = 3)
}

}
\seealso{
\itemize{
\item \code{\link{LOOCV}}
\item \code{\link{MultiWaveAnalysis}}
\item \code{\link{StepDiscrim}}
\item \code{\link{availableFilters}}
\item \code{\link{availableFeatures}}
}
}
