% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{survival_time_quantile}
\alias{survival_time_quantile}
\title{survival_time_quantile}
\usage{
survival_time_quantile(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control parameters}
}
\value{
A quantile of the response survival time.
}
\description{
Computes the quantile of a survival function.
}
\details{
Computes the quantile of a survival function. The user specifies the
percentile associated with the desired quantile in
scoring_function_parameters. The default is percentile = 0.50, which returns
the median survival. A user may also specify a value for the trt_arm parameter
in scoring_function_parameters to compute the survival quantile for only one
arm.
}
\examples{
N <- 200
require( survival )
df <- data.frame( y = survival::Surv( runif( min = 0, max = 20, n = N ),
                            sample( c(0,1), size = N, prob = c(0.2,0.8), replace = TRUE ) ),
                  trt = sample( c('Control','Experimental'), size = N,
                                prob = c(0.4,0.6), replace = TRUE ) )

## Compute median survival time in Experimental treatment arm.
ex1 <- survival_time_quantile( data = df,
                               scoring_function_parameters = list( trt_var = "trt",
                               trt_arm = "Experimental",
                               percentile = 0.50 ) )

## Compute Q1 survival time for all data. It is necessary here to explicitly
## specify trt = NULL because a variable called trt exists in df. The default
## behavior is to use this variable as the treatment variable. To override
## the default behavior trt = NULL is included in scoring_function_parameters.
ex2 <- survival_time_quantile( data = df,
                               scoring_function_parameters = list( trt = NULL,
                                                         percentile = 0.25 ) )
}
\seealso{
\link{TSDT}, \link{diff_survival_time_quantile},
\link[survival]{Surv}, \link[survival]{coxph}, \link[survival]{survfit},
\link[survival]{survreg}, \link[survival]{quantile.survfit},
\link[survival]{predict.coxph}, \link[survival]{predict.survreg}
}
