% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCorrect.R
\name{TCorrect}
\alias{TCorrect}
\title{Temperature correction function}
\usage{
TCorrect(x, ly_SR, ly_T, C, rho, logbase = exp(1), CorrCons = NULL,
  CorrSR = NULL, Manu = NULL, ...)
}
\arguments{
\item{x}{A data frame with \code{\link[VBTree:VBTree-package]{VBTree}} style. Pay attention, all factors in column names
should be separated by "-" symbol, and factors for temperatures and strain rates should be saved in pure numeric style.}

\item{ly_SR}{An integer to specify the layer for strain rate attribute in the vector binary tree.}

\item{ly_T}{An integer to specify the layer for temperature attribute in the vector binary tree.}

\item{C}{Numeric value for heat capacity constant of the material, the unit is J/(kg*K) in SI base.}

\item{rho}{Numeric value for density of the materials, the unit is kg/m^3 in SI base.}

\item{logbase}{A numeric value to specify the base of all logarithm calculations during building model. The default value
uses exp(1).}

\item{CorrCons}{A coefficient from 0 to 1 to specify thermal efficiency. Defualt value is NULL means this coefficient will
be selected dynamically.}

\item{CorrSR}{A coefficient corresponding to strain conditions to build a referential model for temperature correction.
Default value NULL means the program will detect the maximum raw stress values then select a proper strain condition. Referential
model will be built on the basis of that.}

\item{Manu}{An integer vector with the length of 3 where the 1st element denotes the layer for Stress and Strain,
the 2nd and 3rd elements represent the levels for Strain and Stress, respectively. The default setting is NULL, which
can call the function \code{\link[TPMplt:lyIDdetector]{lyIDdetector}} for automatical completion this vector.}

\item{...}{The control parameters pass on to the function \code{\link[TPMplt:AllPF]{AllPF}}. Due to vibration of curves, it is
strongly recommand to set the parameter \code{subsec} experientially on the basis of all the experimental data to be processed.}
}
\value{
A \code{\link[VBTree:VBTree-package]{VBTree}} style data frame with temperature-corrected values for flow stress
in high strain conditions.
}
\description{
Temperature correction function
}
\examples{
# Check the raw data
SSplots(TPMdata, 2, mfrow=c(2, 2))

# The split strain conditions for 'TPMdata' can be set as 0.015 and 0.2
x <- AllPF(TPMdata, subsec = c(0.015, 0.2))
SSplots(x, 2, mfrow=c(2, 2))

# Applying aforementioned subsection conditions for all curves,
# using the parameters of steel as example:
x1 <- TCorrect(TPMdata, 3, 2, 510.7896, 8050, CorrCons = 0.9, subsec=c(0.015, 0.2))
SSplots(x1, 2, mfrow=c(2, 2))
}
\keyword{AllPF}
\keyword{TCorrect}
