% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalTuningParam.R
\name{evalTuningParam}
\alias{evalTuningParam}
\title{Evaluating cross-validation performance of a TPLS_cv model at compvec and threshvec}
\usage{
evalTuningParam(
  TPLScvmdl,
  type = c("Pearson", "negMSE", "ACC", "AUC", "LLbinary", "Spearman"),
  X,
  Y,
  compvec,
  threshvec,
  subfold = NULL
)
}
\arguments{
\item{TPLScvmdl}{TPLS_cv model created from \code{TPLS_cv}}

\item{type}{CV performance metric type. One of LLbinary, negMSE, Pearson, Spearman, AUC, ACC.}

\item{X}{The same X as used in \code{TPLScvmdl}.}

\item{Y}{The SAME Y as used in \code{TPLScvmdl}.}

\item{compvec}{Vector of number of components to test in cross-validation.}

\item{threshvec}{Vector of threshold level (0 ~ 1) to test in cross-validation.}

\item{subfold}{(Optional) vector of subdivision within testing fold to calculate performance. For example scan run division within subject.}
}
\value{
A evalTuningParam object that contains the following attributes.
\itemize{
    \item \code{type}: Cross validation performance measure type, as specified in the input
    \item \code{threshval}: Same as the input threshvec
    \item \code{compval}: Same as the input compvec
    \item \code{perfmat}: Performance measure 3D matrix: length(compvec)-by-length(threshvec)-by-numfold
    \item \code{perf_best}: Best CV performance out of all combinations of compvec and threshvec
    \item \code{compval_best}: Number of components that gave the best performance (i.e., perf_best)
    \item \code{threshval_best}: Threshold level that gave the best performance (i.e., perf_best)
    \item \code{perf_1se} : Performance of the most parsimonious model (least number of coefficients) that is within 1 standard error of perf_best.
    \item \code{compval_1se} : Number of components that gave perf_1se
    \item \code{threshval_1se} : Threshold level that gave perf_1se
    \item \code{best_at_threshold} : a 3-column matrix; first column is max performance at threshold, second column is threshold values, third column is number of components for the best model at threshold
}
}
\description{
Evaluating cross-validation performance of a TPLS_cv model at compvec and threshvec
}
