% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPLS.R
\name{makePredictor}
\alias{makePredictor}
\title{Extracts a predictor (betamap and intercept) from a TPLS model at a given number of components and given threshold value}
\usage{
makePredictor(TPLSmdl, compval, threshval)
}
\arguments{
\item{TPLSmdl}{A TPLS object created from using function \code{TPLS}}

\item{compval}{The number of components you want in your model. Providing a vector will provide multiple betamaps (e.g., c(3,4,5) will provide three betamaps each with 3, 4, and 5 PLS components)}

\item{threshval}{Threshold number between 0 and 1 (inclusive) for thresholding the betamap. This must be a scalar.}
}
\value{
\itemize{
    \item \code{bias}: The intercept of the extracted model. Vector of intercepts if compval is a vector.
    \item \code{betamap}: Column vector of betamap. Matrix of betamaps if compval is a vector.
}
}
\description{
Extracts a predictor (betamap and intercept) from a TPLS model at a given number of components and given threshold value
}
\examples{
# See examples for TPLS
}
