% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.nuts}
\alias{mcmc.nuts}
\title{[BETA VERSION] Draw MCMC samples from a model posterior using the
No-U-Turn (NUTS) sampler with dual averaging.}
\usage{
mcmc.nuts(nsim, fn, gr, params.init, max_doublings = 4, eps = NULL,
  Madapt = NULL, delta = 0.5, covar = NULL, diagnostic = FALSE)
}
\arguments{
\item{nsim}{The number of samples to return.}

\item{fn}{A function that returns the log of the posterior density.}

\item{gr}{A function that returns a vector of gradients of the log of
the posterior density (same as \code{fn}).}

\item{params.init}{A vector of initial parameter values.}

\item{max_doublings}{Integer representing the maximum times the path
length should double within an MCMC iteration. Default of 4, so 16
steps. If a U-turn has not occured before this many steps the algorithm
will stop and return a sample from the given tree.}

\item{eps}{The length of the leapfrog steps. If a numeric value is
passed, it will be used throughout the entire chain. A \code{NULL}
value will initiate adaptation of \code{eps} using the dual averaging
algorithm during the first \code{Madapt} steps.}

\item{Madapt}{An optional argument for how many iterations to adapt
\code{eps} in the dual averaging algorithm. A value of \code{NULL}
results in a default of \code{Madapt=nsim/2}.}

\item{delta}{The target acceptance rate for the dual averaging
algorithm. Defaults to 50\%. NUTS does not include an accept/reject
Metropolis step, so this rate can be understood as the "average acceptance
probability that HMC would give to the position-momentum states explored
during the final doubling iteration."}

\item{covar}{An optional covariance matrix which can be used to improve
the efficiency of sampling. The lower Cholesky decomposition of this
matrix is used to transform the parameter space. If the posterior is
approximately multivariate normal and \code{covar} approximates the
covariance, then the transformed parameter space will be close to
multivariate standard normal. In this case the algorithm will be more
efficient, but there will be overhead in the matrix calculations which
need to be done at each step. The default of NULL specifies to not do
this transformation.}

\item{diagnostic}{Whether to return a list of diagnostic metrics about
the chain. Useful for assessing efficiency and tuning chain.}
}
\value{
If \code{diagnostic} is FALSE (default), returns a matrix
of \code{nsim} samples from the posterior. Otherwise returns a list
containing samples ('par'), vector of steps taken at each iteration
('steps.taken'), and the total function and gradient calls
('n.calls'), which in the case of NUTS is dynamic, and finally the
average \code{eps} ('epsbar') from the dual averaging algorithm if
used (otherwise NULL).
}
\description{
[BETA VERSION] Draw MCMC samples from a model posterior using the
No-U-Turn (NUTS) sampler with dual averaging.
}
\details{
This function implements algorithm 6 of Hoffman and Gelman
(2014), which includes adaptive step sizes (\code{eps}) via an algorithm
called dual averaging. In theory neither the step length nor step size
needs to be input by the user to obtain efficient sampling from the
posterior.
}
\references{
\itemize{
\item{Neal, R. M. (2011). MCMC using Hamiltonian dynamics. Handbook
of Markov Chain Monte Carlo.}
\item{Hoffman and Gelman (2014). The No-U-Turn sampler: Adaptively
setting path lengths in Hamiltonian Monte Carlo. J. Mach. Learn. Res.
15:1593-1623.}
}
}
\seealso{
\code{\link{mcmc}}, \code{\link{mcmc.hmc}}, \code{\link{mcmc.rwm}}
}

